/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.ui.BorderStyle;
import snownee.jade.impl.ui.ProgressStyle;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.WailaTickHandler;

public class ProgressElement
extends Element {
    private final float progress;
    @Nullable
    private final Component text;
    private final ProgressStyle style;
    @Nullable
    private final BorderStyle borderStyle;
    private ProgressTracker.TrackInfo track;

    public ProgressElement(float progress, Component text, ProgressStyle style, BorderStyle borderStyle) {
        this.progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        this.text = text;
        this.style = style;
        this.borderStyle = borderStyle;
    }

    @Override
    public Vec2 getSize() {
        int height = this.text == null ? 8 : 14;
        float width = 0.0f;
        if (this.borderStyle != null) {
            width += (float)(this.borderStyle.width * 2);
        }
        if (this.text != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            width += (float)(font.m_92895_(this.text.getString()) + 3);
        }
        width = Math.max(20.0f, width);
        if (this.getTag() != null) {
            this.track = WailaTickHandler.instance().progressTracker.createInfo(this.getTag(), this.progress, width);
            width = this.track.getWidth();
        }
        return new Vec2(width, (float)height);
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        Vec2 size = this.getCachedSize();
        int b = 0;
        if (this.borderStyle != null) {
            DisplayHelper.INSTANCE.drawBorder(matrixStack, x, y, maxX - 2.0f, y + size.f_82471_ - 2.0f, this.borderStyle);
            b = this.borderStyle.width;
        }
        float progress = this.progress;
        if (this.track == null && this.getTag() != null) {
            this.track = WailaTickHandler.instance().progressTracker.createInfo(this.getTag(), progress, this.getSize().f_82471_);
        }
        if (this.track != null) {
            progress = this.track.tick(Minecraft.m_91087_().m_91297_());
        }
        this.style.render(matrixStack, x + (float)b, y + (float)b, maxX - x - (float)(b * 2) - 2.0f, size.f_82471_ - (float)(b * 2) - 2.0f, progress, this.text);
    }
}

