/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.BorderStyle;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.TooltipRenderer;

public class BoxElement
extends Element {
    private final TooltipRenderer tooltip;
    @Nullable
    private final BorderStyle border;

    public BoxElement(Tooltip tooltip, BorderStyle border) {
        this.tooltip = new TooltipRenderer(tooltip, false);
        this.border = border;
    }

    @Override
    public Vec2 getSize() {
        if (this.tooltip.getTooltip().isEmpty()) {
            return Vec2.f_82462_;
        }
        Vec2 size = this.tooltip.getSize();
        return new Vec2(size.f_82470_ + 2.0f, size.f_82471_ + 4.0f);
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        if (this.tooltip.getTooltip().isEmpty()) {
            return;
        }
        Rect2i rect = this.tooltip.getPosition();
        RenderSystem.m_69478_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        if (this.border != null) {
            DisplayHelper.INSTANCE.drawBorder(matrixStack, 0.0f, 0.0f, rect.m_110090_(), rect.m_110091_(), this.border);
        }
        this.tooltip.draw(matrixStack);
        matrixStack.m_85849_();
    }

    @Override
    @Nullable
    public Component getMessage() {
        if (this.tooltip.getTooltip().isEmpty()) {
            return null;
        }
        return Component.m_237113_((String)this.tooltip.getTooltip().getMessage());
    }
}

