/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.PriorityStore;

public class WailaCommonRegistration
implements IWailaCommonRegistration {
    public static final WailaCommonRegistration INSTANCE = new WailaCommonRegistration();
    public final HierarchyLookup<IServerDataProvider<BlockEntity>> blockDataProviders = new HierarchyLookup(BlockEntity.class);
    public final HierarchyLookup<IServerDataProvider<Entity>> entityDataProviders = new HierarchyLookup(Entity.class);
    public final PriorityStore<IJadeProvider> priorities = new PriorityStore<IJadeProvider>("jade/sort-order", IJadeProvider::getDefaultPriority, IJadeProvider::getUid);

    WailaCommonRegistration() {
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockEntity> dataProvider, Class<? extends BlockEntity> block) {
        this.blockDataProviders.register(block, dataProvider);
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<Entity> dataProvider, Class<? extends Entity> entity) {
        this.entityDataProviders.register(entity, dataProvider);
    }

    public List<IServerDataProvider<BlockEntity>> getBlockNBTProviders(BlockEntity block) {
        return this.blockDataProviders.get(block);
    }

    public List<IServerDataProvider<Entity>> getEntityNBTProviders(Entity entity) {
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.loadComplete(this.priorities);
    }
}

