/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.ConfigEntry;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.overlay.DisplayHelper;

public class WailaClientRegistration
implements IWailaClientRegistration {
    public static final WailaClientRegistration INSTANCE = new WailaClientRegistration();
    public final HierarchyLookup<IBlockComponentProvider> blockIconProviders;
    public final HierarchyLookup<IBlockComponentProvider> blockComponentProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityIconProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityComponentProviders;
    public final Set<Block> hideBlocks = Sets.newHashSet();
    public final Set<EntityType<?>> hideEntities = Sets.newHashSet();
    public final Set<Block> pickBlocks = Sets.newHashSet();
    public final List<JadeAfterRenderCallback> afterRenderCallbacks = Lists.newArrayList();
    public final List<JadeBeforeRenderCallback> beforeRenderCallbacks = Lists.newArrayList();
    public final List<JadeRayTraceCallback> rayTraceCallbacks = Lists.newArrayList();
    public final List<JadeTooltipCollectedCallback> tooltipCollectedCallbacks = Lists.newArrayList();
    public final List<JadeItemModNameCallback> itemModNameCallbacks = Lists.newArrayList();

    WailaClientRegistration() {
        this.blockIconProviders = new HierarchyLookup(Block.class);
        this.blockComponentProviders = new HierarchyLookup(Block.class);
        this.entityIconProviders = new HierarchyLookup(Entity.class);
        this.entityComponentProviders = new HierarchyLookup(Entity.class);
    }

    @Override
    public void registerBlockIcon(IBlockComponentProvider provider, Class<? extends Block> block) {
        this.blockIconProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerBlockComponent(IBlockComponentProvider provider, Class<? extends Block> block) {
        this.blockComponentProviders.register(block, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityIcon(IEntityComponentProvider provider, Class<? extends Entity> entity) {
        this.entityIconProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityComponent(IEntityComponentProvider provider, Class<? extends Entity> entity) {
        this.entityComponentProviders.register(entity, provider);
        this.tryAddConfig(provider);
    }

    public List<IBlockComponentProvider> getBlockProviders(Block block, Predicate<IBlockComponentProvider> filter) {
        return this.blockComponentProviders.get(block).stream().filter(filter).toList();
    }

    public List<IBlockComponentProvider> getBlockIconProviders(Block block, Predicate<IBlockComponentProvider> filter) {
        return this.blockIconProviders.get(block).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityProviders(Entity entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityComponentProviders.get(entity).stream().filter(filter).toList();
    }

    public List<IEntityComponentProvider> getEntityIconProviders(Entity entity, Predicate<IEntityComponentProvider> filter) {
        return this.entityIconProviders.get(entity).stream().filter(filter).toList();
    }

    @Override
    public void hideTarget(Block block) {
        this.hideBlocks.add(block);
    }

    @Override
    public void hideTarget(EntityType<?> entityType) {
        this.hideEntities.add(entityType);
    }

    @Override
    public void usePickedResult(Block block) {
        this.pickBlocks.add(block);
    }

    @Override
    public boolean shouldHide(BlockState state) {
        return this.hideBlocks.contains(state.m_60734_());
    }

    @Override
    public boolean shouldPick(BlockState state) {
        return this.pickBlocks.contains(state.m_60734_());
    }

    @Override
    public boolean shouldHide(Entity entity) {
        return this.hideEntities.contains(entity.m_6095_());
    }

    @Override
    public IElementHelper getElementHelper() {
        return ElementHelper.INSTANCE;
    }

    @Override
    public IDisplayHelper getDisplayHelper() {
        return DisplayHelper.INSTANCE;
    }

    @Override
    public IWailaConfig getConfig() {
        return Jade.CONFIG.get();
    }

    @Override
    public void addConfig(ResourceLocation key, boolean defaultValue) {
        if (!PluginConfig.INSTANCE.getKeys().contains(key)) {
            PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, false));
        }
    }

    private void tryAddConfig(IToggleableProvider provider) {
        if (!provider.isRequired()) {
            this.addConfig(provider.getUid(), provider.enabledByDefault());
        }
    }

    public void loadComplete() {
        PriorityStore<IJadeProvider> priorities = WailaCommonRegistration.INSTANCE.priorities;
        this.blockComponentProviders.loadComplete(priorities);
        this.blockIconProviders.loadComplete(priorities);
        this.entityComponentProviders.loadComplete(priorities);
        this.entityIconProviders.loadComplete(priorities);
    }

    @Override
    public void addAfterRenderCallback(JadeAfterRenderCallback callback) {
        Objects.requireNonNull(callback);
        this.afterRenderCallbacks.add(callback);
    }

    @Override
    public void addBeforeRenderCallback(JadeBeforeRenderCallback callback) {
        Objects.requireNonNull(callback);
        this.beforeRenderCallbacks.add(callback);
    }

    @Override
    public void addRayTraceCallback(JadeRayTraceCallback callback) {
        Objects.requireNonNull(callback);
        this.rayTraceCallbacks.add(callback);
    }

    @Override
    public void addTooltipCollectedCallback(JadeTooltipCollectedCallback callback) {
        Objects.requireNonNull(callback);
        this.tooltipCollectedCallbacks.add(callback);
    }

    @Override
    public void addItemModNameCallback(JadeItemModNameCallback callback) {
        Objects.requireNonNull(callback);
        this.itemModNameCallbacks.add(callback);
    }

    @Override
    public BlockAccessor.Builder blockAccessor() {
        return new BlockAccessorImpl.Builder();
    }

    @Override
    public EntityAccessor.Builder entityAccessor() {
        return new EntityAccessorImpl.Builder();
    }
}

