/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.phys.Vec2;
import snownee.jade.Jade;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.ui.IBorderStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.BorderStyle;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.overlay.DisplayHelper;

public class Tooltip
implements ITooltip {
    public final List<Line> lines = new ArrayList<Line>();
    public boolean sneakyDetails;
    private static final IBorderStyle RED = new BorderStyle().color(-1996554240);
    private static final IBorderStyle BLUE = new BorderStyle().color(-2013265665);

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public void append(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        if (this.isEmpty() || index == this.size()) {
            this.add(element);
        } else {
            Line lastLine = this.lines.get(index);
            lastLine.getAlignedElements(element.getAlignment()).add(element);
        }
    }

    @Override
    public IElementHelper getElementHelper() {
        return ElementHelper.INSTANCE;
    }

    @Override
    public int size() {
        return this.lines.size();
    }

    @Override
    public void add(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        Line line = new Line();
        line.getAlignedElements(element.getAlignment()).add(element);
        this.lines.add(index, line);
    }

    @Override
    public List<IElement> get(ResourceLocation tag) {
        ArrayList elements = Lists.newArrayList();
        for (Line line : this.lines) {
            line.left.stream().filter(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag())).forEach(elements::add);
            line.right.stream().filter(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag())).forEach(elements::add);
        }
        return elements;
    }

    @Override
    public List<IElement> get(int index, IElement.Align align) {
        Line line = this.lines.get(index);
        return line.getAlignedElements(align);
    }

    @Override
    public void remove(ResourceLocation tag) {
        Iterator<Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Line line = iterator.next();
            line.left.removeIf(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag()));
            line.right.removeIf(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag()));
            if (!line.left.isEmpty() || !line.right.isEmpty()) continue;
            iterator.remove();
        }
    }

    public static void drawBorder(PoseStack matrixStack, float x, float y, IElement element) {
        if (Jade.CONFIG.get().getGeneral().isDebug()) {
            Vec2 translate = element.getTranslation();
            Vec2 size = element.getCachedSize();
            DisplayHelper.INSTANCE.drawBorder(matrixStack, x, y, x + size.f_82470_, y + size.f_82471_, RED);
            if (!Vec2.f_82462_.m_82476_(translate)) {
                DisplayHelper.INSTANCE.drawBorder(matrixStack, x + translate.f_82470_, y + translate.f_82471_, x + translate.f_82470_ + size.f_82470_, y + translate.f_82471_ + size.f_82471_, BLUE);
            }
        }
    }

    @Override
    public String getMessage() {
        ArrayList msgs = Lists.newArrayList();
        for (Line line : this.lines) {
            msgs.add(Joiner.on((char)' ').join(Stream.concat(line.left.stream(), line.right.stream()).filter(e -> !Identifiers.CORE_MOD_NAME.equals((Object)e.getTag())).map(IElement::getCachedMessage).filter(Objects::nonNull).map(StringDecomposer::m_14326_).toList()));
        }
        return Joiner.on((char)'\n').join((Iterable)msgs);
    }

    public static class Line {
        private final List<IElement> left = new ArrayList<IElement>();
        private final List<IElement> right = new ArrayList<IElement>();
        private Vec2 size;

        public List<IElement> getAlignedElements(IElement.Align align) {
            return align == IElement.Align.LEFT ? this.left : this.right;
        }

        public Vec2 getSize() {
            if (this.size == null) {
                Vec2 elementSize;
                float width = 0.0f;
                float height = 0.0f;
                for (IElement element : this.left) {
                    elementSize = element.getCachedSize();
                    width += elementSize.f_82470_;
                    height = Math.max(height, elementSize.f_82471_);
                }
                for (IElement element : this.right) {
                    elementSize = element.getCachedSize();
                    width += elementSize.f_82470_;
                    height = Math.max(height, elementSize.f_82471_);
                }
                this.size = new Vec2(width, height);
            }
            return this.size;
        }

        public void render(PoseStack matrixStack, float x, float y, float maxWidth, float y2) {
            Vec2 size;
            Vec2 translate;
            float ox = maxWidth;
            float oy = y;
            for (int i = this.right.size() - 1; i >= 0; --i) {
                IElement element = this.right.get(i);
                translate = element.getTranslation();
                size = element.getCachedSize();
                Tooltip.drawBorder(matrixStack, ox -= size.f_82470_, oy, element);
                element.render(matrixStack, ox + translate.f_82470_, oy + translate.f_82471_, x + maxWidth, y + y2);
            }
            maxWidth = ox;
            ox = x;
            for (IElement element : this.left) {
                translate = element.getTranslation();
                size = element.getCachedSize();
                Tooltip.drawBorder(matrixStack, ox, oy, element);
                element.render(matrixStack, ox + translate.f_82470_, oy + translate.f_82471_, maxWidth, y + y2);
                ox += size.f_82470_;
            }
        }
    }
}

