/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;

public class PriorityStore<T> {
    private final Object2IntMap<ResourceLocation> priorities = new Object2IntOpenHashMap();
    private final Function<T, ResourceLocation> uidGetter;
    private final ToIntFunction<T> defaultGetter;

    public PriorityStore(String filename, ToIntFunction<T> defaultGetter, Function<T, ResourceLocation> uidGetter) {
        this.defaultGetter = defaultGetter;
        this.uidGetter = uidGetter;
    }

    public void put(T provider) {
        Objects.requireNonNull(provider);
        ResourceLocation uid = this.uidGetter.apply(provider);
        Objects.requireNonNull(uid);
        this.priorities.put((Object)uid, this.defaultGetter.applyAsInt(provider));
    }

    public void updateConfig() {
    }

    public int get(T value) {
        return this.get(this.uidGetter.apply(value));
    }

    public int get(ResourceLocation id) {
        return this.priorities.getInt((Object)id);
    }
}

