/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorImpl
extends AccessorImpl<EntityHitResult>
implements EntityAccessor {
    private final Entity entity;

    public EntityAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, builder.hit, builder.connected);
        this.entity = builder.entity;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public ItemStack getPickedResult() {
        return ClientPlatformProxy.getEntityPickedResult(this.entity, this.getPlayer(), (EntityHitResult)this.getHitResult());
    }

    @Override
    public IElement _getIcon() {
        IElement icon = null;
        if (this.entity instanceof ItemEntity) {
            icon = ItemStackElement.of(((ItemEntity)this.entity).m_32055_());
        } else {
            ItemStack stack = this.getPickedResult();
            if (!(stack.m_41720_() instanceof SpawnEggItem) || !(this.entity instanceof LivingEntity)) {
                icon = ItemStackElement.of(stack);
            }
        }
        for (IEntityComponentProvider provider : WailaClientRegistration.INSTANCE.getEntityIconProviders(this.entity, PluginConfig.INSTANCE::get)) {
            try {
                IElement element = provider.getIcon(this, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _gatherComponents(Function<IJadeProvider, ITooltip> tooltipProvider) {
        List<IEntityComponentProvider> providers = WailaClientRegistration.INSTANCE.getEntityProviders(this.getEntity(), PluginConfig.INSTANCE::get);
        for (IEntityComponentProvider provider : providers) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                ElementHelper.INSTANCE.setCurrentUid(provider.getUid());
                provider.appendTooltip(tooltip, this, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip);
            }
            finally {
                ElementHelper.INSTANCE.setCurrentUid(null);
            }
        }
    }

    @Override
    public boolean shouldDisplay() {
        return Jade.CONFIG.get().getGeneral().getDisplayEntities();
    }

    @Override
    public void _requestData(boolean showDetails) {
        ClientPlatformProxy.requestEntityData(this.entity, showDetails);
    }

    @Override
    public boolean shouldRequestData() {
        return !WailaCommonRegistration.INSTANCE.getEntityNBTProviders(this.entity).isEmpty();
    }

    @Override
    public boolean _verifyData(CompoundTag serverData) {
        if (!serverData.m_128441_("WailaEntityID")) {
            return false;
        }
        return serverData.m_128451_("WailaEntityID") == this.entity.m_19879_();
    }

    @Override
    public Object _getTrackObject() {
        return this.getEntity();
    }

    public static class Builder
    implements EntityAccessor.Builder {
        private Level level;
        private Player player;
        private CompoundTag serverData;
        private boolean connected;
        private EntityHitResult hit;
        private Entity entity;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder hit(EntityHitResult hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder entity(Entity entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder from(EntityAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.hit = (EntityHitResult)accessor.getHitResult();
            this.entity = accessor.getEntity();
            return this;
        }

        @Override
        public EntityAccessor build() {
            return new EntityAccessorImpl(this);
        }
    }
}

