/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorImpl
extends AccessorImpl<BlockHitResult>
implements BlockAccessor {
    private final BlockState blockState;
    private final BlockEntity blockEntity;
    private final ItemStack fakeBlock;

    private BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, builder.hit, builder.connected);
        this.blockState = builder.blockState;
        this.blockEntity = builder.blockEntity;
        this.fakeBlock = builder.fakeBlock;
    }

    @Override
    public Block getBlock() {
        return this.getBlockState().m_60734_();
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public BlockPos getPosition() {
        return ((BlockHitResult)this.getHitResult()).m_82425_();
    }

    @Override
    public Direction getSide() {
        return ((BlockHitResult)this.getHitResult()).m_82434_();
    }

    @Override
    public ItemStack getPickedResult() {
        return ClientPlatformProxy.getBlockPickedResult(this.blockState, this.getPlayer(), (BlockHitResult)this.getHitResult());
    }

    @Override
    public IElement _getIcon() {
        if (this.blockState.m_60795_()) {
            return null;
        }
        IElement icon = null;
        if (this.isFakeBlock()) {
            icon = ItemStackElement.of(this.getFakeBlock());
        } else {
            ItemStack pick = this.getPickedResult();
            if (!pick.m_41619_()) {
                icon = ItemStackElement.of(pick);
            }
        }
        if (RayTracing.isEmptyElement(icon) && this.getBlock().m_5456_() != Items.f_41852_) {
            icon = ItemStackElement.of(new ItemStack((ItemLike)this.getBlock()));
        }
        if (RayTracing.isEmptyElement(icon) && this.getBlock() instanceof LiquidBlock) {
            icon = ClientPlatformProxy.elementFromLiquid((LiquidBlock)this.getBlock());
        }
        for (IBlockComponentProvider provider : WailaClientRegistration.INSTANCE.getBlockIconProviders(this.getBlock(), PluginConfig.INSTANCE::get)) {
            try {
                IElement element = provider.getIcon(this, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _gatherComponents(Function<IJadeProvider, ITooltip> tooltipProvider) {
        List<IBlockComponentProvider> providers = WailaClientRegistration.INSTANCE.getBlockProviders(this.getBlock(), PluginConfig.INSTANCE::get);
        for (IBlockComponentProvider provider : providers) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                ElementHelper.INSTANCE.setCurrentUid(provider.getUid());
                provider.appendTooltip(tooltip, this, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip);
            }
            finally {
                ElementHelper.INSTANCE.setCurrentUid(null);
            }
        }
    }

    @Override
    public boolean shouldDisplay() {
        return Jade.CONFIG.get().getGeneral().getDisplayBlocks();
    }

    @Override
    public void _requestData(boolean showDetails) {
        ClientPlatformProxy.requestBlockData(this.blockEntity, showDetails);
    }

    @Override
    public boolean shouldRequestData() {
        if (this.blockEntity == null) {
            return false;
        }
        return !WailaCommonRegistration.INSTANCE.getBlockNBTProviders(this.blockEntity).isEmpty();
    }

    @Override
    public boolean _verifyData(CompoundTag serverData) {
        int x = serverData.m_128451_("x");
        int y = serverData.m_128451_("y");
        int z = serverData.m_128451_("z");
        BlockPos hitPos = this.getPosition();
        return x == hitPos.m_123341_() && y == hitPos.m_123342_() && z == hitPos.m_123343_();
    }

    @Override
    public Object _getTrackObject() {
        return this.getBlockEntity();
    }

    @Override
    public boolean isFakeBlock() {
        return !this.fakeBlock.m_41619_();
    }

    @Override
    public ItemStack getFakeBlock() {
        return this.fakeBlock;
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private Level level;
        private Player player;
        private CompoundTag serverData;
        private boolean connected;
        private BlockHitResult hit;
        private BlockState blockState = Blocks.f_50016_.m_49966_();
        private BlockEntity blockEntity;
        private ItemStack fakeBlock = ItemStack.f_41583_;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder hit(BlockHitResult hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder blockState(BlockState blockState) {
            this.blockState = blockState;
            return this;
        }

        @Override
        public Builder blockEntity(BlockEntity blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        @Override
        public Builder fakeBlock(ItemStack stack) {
            this.fakeBlock = stack;
            return this;
        }

        @Override
        public Builder from(BlockAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.hit = (BlockHitResult)accessor.getHitResult();
            this.blockEntity = accessor.getBlockEntity();
            this.blockState = accessor.getBlockState();
            this.fakeBlock = accessor.getFakeBlock();
            return this;
        }

        @Override
        public BlockAccessor build() {
            return new BlockAccessorImpl(this);
        }
    }
}

