/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import snownee.jade.gui.config.WailaOptionsList;
import snownee.jade.gui.config.value.OptionValue;

public abstract class BaseOptionsScreen
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    private WailaOptionsList options;
    private final Set<GuiEventListener> entryWidgets = Sets.newIdentityHashSet();

    public BaseOptionsScreen(Screen parent, Component title, Runnable saver, Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public BaseOptionsScreen(Screen parent, String title, Runnable saver, Runnable canceller) {
        this(parent, WailaOptionsList.Entry.makeTitle(title), saver, canceller);
    }

    public BaseOptionsScreen(Screen parent, String title) {
        this(parent, title, null, null);
    }

    protected void m_7856_() {
        this.entryWidgets.clear();
        this.options = this.getOptions();
        this.m_142416_((GuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 25, 100, 20, (Component)Component.m_237115_((String)"gui.done"), w -> {
                this.options.save();
                this.saver.run();
                this.f_96541_.m_91152_(this.parent);
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 25, 100, 20, (Component)Component.m_237115_((String)"gui.cancel"), w -> {
                this.canceller.run();
                this.f_96541_.m_91152_(this.parent);
            }));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20, (Component)Component.m_237115_((String)"gui.done"), w -> {
                this.options.save();
                this.f_96541_.m_91152_(this.parent);
            }));
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        WailaOptionsList.Entry entry;
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (mouseY >= 32 && mouseY <= this.f_96544_ - 32 && (entry = (WailaOptionsList.Entry)this.options.m_93511_()) instanceof OptionValue) {
            OptionValue value = (OptionValue)entry;
            AbstractWidget widget = value.getListener();
            if (widget instanceof TooltipAccessor && widget.f_93624_ && mouseX >= widget.f_93620_ && mouseY >= widget.f_93621_ && mouseX < widget.f_93620_ + widget.m_5711_() && mouseY < widget.f_93621_ + widget.m_93694_()) {
                this.m_96617_(matrixStack, ((TooltipAccessor)widget).m_141932_(), mouseX, mouseY);
            } else if (I18n.m_118936_((String)value.getDescription())) {
                int valueX = value.getX() + 10;
                String title = value.getTitle().getString();
                if (mouseX >= valueX && mouseX <= valueX + this.f_96547_.m_92895_(title)) {
                    ArrayList tooltip = Lists.newArrayList((Object[])new FormattedCharSequence[]{value.getTitle().m_7532_()});
                    List tooltip2 = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)value.getDescription()), 200);
                    tooltip.addAll(tooltip2);
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(0.0, 0.0, 100.0);
                    this.m_96617_(matrixStack, tooltip, mouseX, mouseY);
                    RenderSystem.m_69482_();
                    matrixStack.m_85849_();
                }
            }
        }
    }

    public abstract WailaOptionsList getOptions();

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.options.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        super.m_7379_();
    }

    public <T extends GuiEventListener & NarratableEntry> T addEntryWidget(T widget) {
        this.entryWidgets.add(widget);
        return (T)super.m_7787_(widget);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_94697_) {
        boolean onList = this.options.m_5953_(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.m_6702_()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.m_6375_(mouseX, mouseY, p_94697_)) continue;
            this.m_7522_(guieventlistener);
            if (p_94697_ == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        boolean onList = this.options.m_5953_(mouseX, mouseY);
        for (GuiEventListener guieventlistener : this.m_6702_()) {
            if (!onList && this.entryWidgets.contains(guieventlistener) || !guieventlistener.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(guieventlistener);
        }
        return Optional.empty();
    }
}

