/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.overlay.DisplayHelper;

public enum TotalEnchantmentPowerProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Level world = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        float power = 0.0f;
        for (int k = -1; k <= 1; ++k) {
            for (int l = -1; l <= 1; ++l) {
                if (k == 0 && l == 0 || !world.m_46859_(pos.m_7918_(l, 0, k)) || !world.m_46859_(pos.m_7918_(l, 1, k))) continue;
                power += TotalEnchantmentPowerProvider.getPower(world, pos.m_7918_(l * 2, 0, k * 2));
                power += TotalEnchantmentPowerProvider.getPower(world, pos.m_7918_(l * 2, 1, k * 2));
                if (l == 0 || k == 0) continue;
                power += TotalEnchantmentPowerProvider.getPower(world, pos.m_7918_(l * 2, 0, k));
                power += TotalEnchantmentPowerProvider.getPower(world, pos.m_7918_(l * 2, 1, k));
                power += TotalEnchantmentPowerProvider.getPower(world, pos.m_7918_(l, 0, k * 2));
                power += TotalEnchantmentPowerProvider.getPower(world, pos.m_7918_(l, 1, k * 2));
            }
        }
        if (power > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"jade.ench_power", (Object[])new Object[]{DisplayHelper.dfCommas.format(power)}));
        }
    }

    public static float getPower(Level world, BlockPos pos) {
        return world.m_8055_(pos).getEnchantPowerBonus((LevelReader)world, pos);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_TOTAL_ENCHANTMENT_POWER;
    }

    @Override
    public int getDefaultPriority() {
        return -400;
    }
}

