/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import snownee.jade.JadeCommonConfig;
import snownee.jade.addon.forge.BlockInventoryProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.util.PlatformProxy;

public enum ContainerEntityProvider implements IEntityComponentProvider,
IServerDataProvider<Entity>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        BlockInventoryProvider.append(tooltip, accessor);
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, Entity t, boolean showDetails) {
        AbstractChestedHorse horse;
        int size;
        int n = size = showDetails ? JadeCommonConfig.inventoryDetailedShowAmount : JadeCommonConfig.inventoryNormalShowAmount;
        if (size == 0) {
            return;
        }
        if (t instanceof AbstractChestedHorse && (horse = (AbstractChestedHorse)t).m_30502_()) {
            PlatformProxy.putHorseInvData(horse, data, size);
            return;
        }
        if (t instanceof ContainerEntity) {
            ContainerEntity entity = (ContainerEntity)t;
            if (entity.m_214142_() != null) {
                data.m_128379_("Loot", true);
                return;
            }
            if (!entity.m_7983_()) {
                BlockInventoryProvider.putInvData(data, (IItemHandler)new InvWrapper((Container)entity), size, 0);
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_CONTAINER_ENTITY;
    }
}

