/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.forge;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;

public enum ForgeEnergyProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity tile = accessor.getBlockEntity();
        if (tile == null) {
            return;
        }
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (storage != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeEnergy"))) {
            int max;
            int cur;
            IElementHelper helper = tooltip.getElementHelper();
            if (accessor.isServerConnected()) {
                cur = accessor.getServerData().m_128451_("jadeEnergy");
                max = accessor.getServerData().m_128451_("jadeMaxEnergy");
            } else {
                cur = storage.getEnergyStored();
                max = storage.getMaxEnergyStored();
            }
            String curText = ChatFormatting.WHITE + VanillaPlugin.getDisplayHelper().humanReadableNumber(cur, "FE", false) + ChatFormatting.GRAY;
            String maxText = VanillaPlugin.getDisplayHelper().humanReadableNumber(max, "FE", false);
            MutableComponent text = Component.m_237110_((String)"jade.fe", (Object[])new Object[]{curText, maxText}).m_130940_(ChatFormatting.GRAY);
            IProgressStyle progressStyle = helper.progressStyle().color(-65536, -10092544);
            tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, helper.borderStyle()));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity tile, boolean showDetails) {
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (storage != null) {
            data.m_128405_("jadeEnergy", storage.getEnergyStored());
            data.m_128405_("jadeMaxEnergy", storage.getMaxEnergyStored());
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.FORGE_ENERGY;
    }
}

