/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.class_2960;
import snownee.jade.api.config.Theme;
import snownee.jade.util.Color;

public class ThemeSerializer
implements JsonDeserializer<Theme>,
JsonSerializer<Theme> {
    public JsonElement serialize(Theme src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        o.addProperty("id", src.id.toString());
        o.addProperty("backgroundColor", src.backgroundColor);
        o.addProperty("gradientStart", src.gradientStart);
        o.addProperty("gradientEnd", src.gradientEnd);
        o.addProperty("titleColor", src.stressedTextColor);
        o.addProperty("textColor", src.normalTextColor);
        o.addProperty("textShadow", Boolean.valueOf(src.textShadow));
        return o;
    }

    public Theme deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject o = json.getAsJsonObject();
        class_2960 id = class_2960.method_12829((String)o.get("id").getAsString());
        String backgroundColor = this.readColor(o, "backgroundColor");
        String gradientStart = this.readColor(o, "gradientStart");
        String gradientEnd = this.readColor(o, "gradientEnd");
        String titleColor = this.readColor(o, "titleColor");
        String textColor = this.readColor(o, "textColor");
        boolean textShadow = o.get("textShadow").getAsBoolean();
        return new Theme(id, backgroundColor, gradientStart, gradientEnd, titleColor, textColor, textShadow);
    }

    private String readColor(JsonObject o, String s) {
        JsonPrimitive e = o.get(s).getAsJsonPrimitive();
        if (e.isString()) {
            Color color = Color.fromString(e.getAsString());
            return color == null ? "#000" : e.getAsString();
        }
        int c = e.getAsInt();
        byte a = (byte)(c >> 24 & 0xFF);
        byte r = (byte)(c >> 16 & 0xFF);
        byte g = (byte)(c >> 8 & 0xFF);
        byte b = (byte)(c & 0xFF);
        return Color.fromRGB(r, g, b, a).toHex(true);
    }
}

