/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2384;
import net.minecraft.class_239;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2531;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3528;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4587;
import net.minecraft.class_636;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.HomeConfigScreen;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.mixin.KeyAccess;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.PlatformProxy;

public final class JadeClient
implements ClientModInitializer {
    public static class_304 openConfig;
    public static class_304 showOverlay;
    public static class_304 toggleLiquid;
    public static class_304 narrate;
    public static class_304 showRecipes;
    public static class_304 showUses;
    private static boolean translationChecked;
    public static boolean hideModName;
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    public void onInitializeClient() {
        ClientPlatformProxy.init();
        for (int i = 320; i < 330; ++i) {
            class_3675.class_306 key = class_3675.class_307.field_1668.method_1447(i);
            ((KeyAccess)key).setDisplayName((class_3528<class_2561>)new class_3528(() -> class_2561.method_43471((String)key.method_1441())));
        }
        openConfig = ClientPlatformProxy.registerKeyBinding("config", 320);
        showOverlay = ClientPlatformProxy.registerKeyBinding("show_overlay", 321);
        toggleLiquid = ClientPlatformProxy.registerKeyBinding("toggle_liquid", 322);
        if (ClientPlatformProxy.shouldRegisterRecipeViewerKeys()) {
            showRecipes = ClientPlatformProxy.registerKeyBinding("show_recipes", 323);
            showUses = ClientPlatformProxy.registerKeyBinding("show_uses", 324);
        }
        narrate = ClientPlatformProxy.registerKeyBinding("narrate", 325);
        ClientPlatformProxy.registerReloadListener(ModIdentification.INSTANCE);
    }

    public static void onKeyPressed(int action) {
        while (openConfig.method_1436()) {
            Jade.CONFIG.invalidate();
            class_310.method_1551().method_1507((class_437)new HomeConfigScreen(null));
        }
        while (showOverlay.method_1436()) {
            IWailaConfig.DisplayMode mode = Jade.CONFIG.get().getGeneral().getDisplayMode();
            if (mode != IWailaConfig.DisplayMode.TOGGLE) continue;
            Jade.CONFIG.get().getGeneral().setDisplayTooltip(!Jade.CONFIG.get().getGeneral().shouldDisplayTooltip());
        }
        while (toggleLiquid.method_1436()) {
            Jade.CONFIG.get().getGeneral().setDisplayFluids(!Jade.CONFIG.get().getGeneral().shouldDisplayFluids());
        }
        while (narrate.method_1436()) {
            if (Jade.CONFIG.get().getGeneral().getTTSMode() == IWailaConfig.TTSMode.TOGGLE) {
                Jade.CONFIG.get().getGeneral().toggleTTS();
                continue;
            }
            if (WailaTickHandler.instance().tooltipRenderer == null) continue;
            WailaTickHandler.narrate(WailaTickHandler.instance().tooltipRenderer.getTooltip(), false);
        }
    }

    public static void onGui(class_437 screen) {
        if (!translationChecked && screen instanceof class_442 && PlatformProxy.isDevEnv()) {
            translationChecked = true;
            ArrayList keys = Lists.newArrayList();
            for (class_2960 id : PluginConfig.INSTANCE.getKeys()) {
                String key = "config.jade.plugin_%s.%s".formatted(id.method_12836(), id.method_12832());
                if (class_1074.method_4663((String)key)) continue;
                keys.add(key);
            }
            if (!keys.isEmpty()) {
                throw new AssertionError((Object)"Missing config translation: %s".formatted(Joiner.on((char)',').join((Iterable)keys)));
            }
        }
    }

    public static void onTooltip(List<class_2561> tooltip, class_1799 stack) {
        JadeClient.appendModName(tooltip, stack);
        if (Jade.CONFIG.get().getGeneral().isDebug() && stack.method_7985()) {
            tooltip.add(class_2512.method_32270((class_2520)stack.method_7969()));
        }
    }

    private static void appendModName(List<class_2561> tooltip, class_1799 stack) {
        if (hideModName || !Jade.CONFIG.get().getGeneral().showItemModNameTooltip()) {
            return;
        }
        String name = String.format(Jade.CONFIG.get().getFormatting().getModName(), ModIdentification.getModName(stack));
        tooltip.add((class_2561)class_2561.method_43470((String)name));
    }

    @Nullable
    public static Accessor<?> builtInOverrides(class_239 hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        class_1657 player = accessor.getPlayer();
        if (player.method_7337() || player.method_7325()) {
            return accessor;
        }
        IWailaClientRegistration client = VanillaPlugin.CLIENT_REGISTRATION;
        if (accessor instanceof BlockAccessor) {
            BlockAccessor target = (BlockAccessor)accessor;
            if (target.getBlock() instanceof class_2531) {
                class_2680 state = VanillaPlugin.getCorrespondingNormalChest(target.getBlockState());
                if (state != target.getBlockState()) {
                    return client.blockAccessor().from(target).blockState(state).build();
                }
            } else {
                if (target.getBlock() instanceof class_2384) {
                    class_2248 block = ((class_2384)target.getBlock()).method_10271();
                    return client.blockAccessor().from(target).blockState(block.method_9564()).build();
                }
                if (target.getBlock() == class_2246.field_27879) {
                    class_2248 block = class_2246.field_10491;
                    return client.blockAccessor().from(target).blockState(block.method_9564()).build();
                }
            }
        }
        return accessor;
    }

    public static void drawBreakingProgress(ITooltip tooltip, class_768 rect, class_4587 matrixStack, Accessor<?> accessor) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        class_310 mc = class_310.method_1551();
        class_636 playerController = mc.field_1761;
        if (playerController == null || playerController.field_3714 == null) {
            return;
        }
        class_2680 state = mc.field_1687.method_8320(playerController.field_3714);
        if (playerController.method_2923()) {
            canHarvest = PlatformProxy.isCorrectToolForDrops(state, (class_1657)mc.field_1724);
        }
        int color = canHarvest ? 0xFFFFFF : 0xFF4444;
        int height = rect.method_3320();
        int width = rect.method_3319();
        if (!VanillaPlugin.CLIENT_REGISTRATION.getConfig().getOverlay().getSquare()) {
            --height;
            width -= 2;
        }
        progressAlpha += mc.method_1534() * (playerController.method_2923() ? 0.1f : -0.1f);
        if (playerController.method_2923()) {
            progressAlpha = Math.min(progressAlpha, 0.53f);
            float progress = state.method_26165((class_1657)mc.field_1724, (class_1922)mc.field_1724.field_6002, playerController.field_3714);
            if (playerController.field_3715 + progress >= 1.0f) {
                progressAlpha = 1.0f;
            }
            progress = playerController.field_3715 + mc.method_1488() * progress;
            savedProgress = progress = class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f);
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        color = IWailaConfig.IConfigOverlay.applyAlpha(color, progressAlpha);
        DisplayHelper.fill(matrixStack, 0.0f, (float)(height - 1), (float)width * savedProgress, (float)height, color);
    }
}

