/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.Theme;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.ConfigEntry;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.PlatformProxy;
import snownee.jade.util.ThemeSerializer;
import snownee.jade.util.UsernameCache;
import snownee.jade.util.WailaExceptionHandler;

public class Jade
implements ModInitializer {
    public static final String MODID = "jade";
    public static final String NAME = "Jade";
    public static final Logger LOGGER = LogManager.getLogger((String)"Jade");
    public static final class_241 SMALL_ITEM_SIZE = new class_241(10.0f, 10.0f);
    public static final class_241 SMALL_ITEM_OFFSET = class_241.field_1344;
    public static final JsonConfig<WailaConfig> CONFIG = new JsonConfig<WailaConfig>("jade/jade", WailaConfig.class, () -> OverlayRenderer.updateTheme()).withGson(new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(Theme.class, (Object)new ThemeSerializer()).create());
    public static int MAX_DISTANCE_SQR = 900;

    public static IElement smallItem(IElementHelper elements, class_1799 stack) {
        return elements.item(stack, 0.5f).size(SMALL_ITEM_SIZE).translate(SMALL_ITEM_OFFSET).message(null);
    }

    public void onInitialize() {
        PlatformProxy.init();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Identifiers.PACKET_REQUEST_ENTITY, (server, player, handler, buf, responseSender) -> {
            class_1937 world = player.field_6002;
            class_1297 entity = world.method_8469(buf.method_10816());
            boolean showDetails = buf.readBoolean();
            if (entity == null || player.method_5858(entity) > (double)MAX_DISTANCE_SQR) {
                return;
            }
            server.execute(() -> {
                List<IServerDataProvider<class_1297>> providers = WailaCommonRegistration.INSTANCE.getEntityNBTProviders(entity);
                if (providers.isEmpty()) {
                    return;
                }
                class_2487 tag = new class_2487();
                for (IServerDataProvider<class_1297> provider : providers) {
                    try {
                        provider.appendServerData(tag, player, world, entity, showDetails);
                    }
                    catch (Exception e) {
                        WailaExceptionHandler.handleErr(e, provider, null);
                    }
                }
                tag.method_10569("WailaEntityID", entity.method_5628());
                class_2540 re = PacketByteBufs.create();
                re.method_10794(tag);
                responseSender.sendPacket(Identifiers.PACKET_RECEIVE_DATA, re);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Identifiers.PACKET_REQUEST_TILE, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            boolean showDetails = buf.readBoolean();
            class_1937 world = player.field_6002;
            if (pos.method_10262((class_2382)player.method_24515()) > (double)MAX_DISTANCE_SQR || !world.method_8477(pos)) {
                return;
            }
            server.execute(() -> {
                class_2586 tile = world.method_8321(pos);
                if (tile == null) {
                    return;
                }
                List<IServerDataProvider<class_2586>> providers = WailaCommonRegistration.INSTANCE.getBlockNBTProviders(tile);
                if (providers.isEmpty()) {
                    return;
                }
                class_2487 tag = new class_2487();
                for (IServerDataProvider<class_2586> provider : providers) {
                    try {
                        provider.appendServerData(tag, player, world, tile, showDetails);
                    }
                    catch (Exception e) {
                        WailaExceptionHandler.handleErr(e, provider, null);
                    }
                }
                tag.method_10569("x", pos.method_10263());
                tag.method_10569("y", pos.method_10264());
                tag.method_10569("z", pos.method_10260());
                tag.method_10582("id", PlatformProxy.getId(tile.method_11017()).toString());
                class_2540 re = PacketByteBufs.create();
                re.method_10794(tag);
                responseSender.sendPacket(Identifiers.PACKET_RECEIVE_DATA, re);
            });
        });
        ServerPlayConnectionEvents.JOIN.register(this::playerJoin);
        UsernameCache.load();
        this.loadComplete();
    }

    private void loadComplete() {
        FabricLoader.getInstance().getEntrypointContainers(MODID, IWailaPlugin.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            LOGGER.info("Start loading plugin from {}", (Object)modId);
            String className = null;
            try {
                IWailaPlugin plugin = (IWailaPlugin)entrypoint.getEntrypoint();
                className = plugin.getClass().getName();
                plugin.register(WailaCommonRegistration.INSTANCE);
                if (PlatformProxy.isPhysicallyClient()) {
                    plugin.registerClient(WailaClientRegistration.INSTANCE);
                }
            }
            catch (Throwable e) {
                LOGGER.error("Error loading plugin at {}", className, (Object)e);
            }
        });
        WailaCommonRegistration.INSTANCE.priorities.updateConfig();
        WailaCommonRegistration.INSTANCE.loadComplete();
        if (PlatformProxy.isPhysicallyClient()) {
            WailaClientRegistration.INSTANCE.loadComplete();
        }
        PluginConfig.INSTANCE.reload();
    }

    private void playerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 player = handler.field_14140;
        LOGGER.info("Syncing config to {} ({})", (Object)player.method_7334().getName(), (Object)player.method_7334().getId());
        Set<ConfigEntry> entries = PluginConfig.INSTANCE.getSyncableConfigs();
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(entries.size());
        entries.forEach(e -> {
            buf.method_10814(e.getId().toString());
            buf.writeBoolean(e.getValue());
        });
        ServerPlayNetworking.send((class_3222)player, (class_2960)Identifiers.PACKET_SERVER_PING, (class_2540)buf);
        if (server.method_3816()) {
            UsernameCache.setUsername(player.method_5667(), player.method_7334().getName());
        }
    }
}

