/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3966;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.PlatformProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorImpl
extends AccessorImpl<class_3966>
implements EntityAccessor {
    private final class_1297 entity;

    public EntityAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, builder.hit, builder.connected, builder.showDetails);
        this.entity = builder.entity;
    }

    @Override
    public class_1297 getEntity() {
        return this.entity;
    }

    @Override
    public class_1799 getPickedResult() {
        return ClientPlatformProxy.getEntityPickedResult(this.entity, this.getPlayer(), (class_3966)this.getHitResult());
    }

    @Override
    public IElement _getIcon() {
        IElement icon = null;
        if (this.entity instanceof class_1542) {
            icon = ItemStackElement.of(((class_1542)this.entity).method_6983());
        } else {
            class_1799 stack = this.getPickedResult();
            if (!(stack.method_7909() instanceof class_1826) || !(this.entity instanceof class_1309)) {
                icon = ItemStackElement.of(stack);
            }
        }
        for (IEntityComponentProvider provider : WailaClientRegistration.INSTANCE.getEntityIconProviders(this.entity, PluginConfig.INSTANCE::get)) {
            try {
                IElement element = provider.getIcon(this, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _gatherComponents(Function<IJadeProvider, ITooltip> tooltipProvider) {
        List<IEntityComponentProvider> providers = WailaClientRegistration.INSTANCE.getEntityProviders(this.getEntity(), PluginConfig.INSTANCE::get);
        for (IEntityComponentProvider provider : providers) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                ElementHelper.INSTANCE.setCurrentUid(provider.getUid());
                provider.appendTooltip(tooltip, this, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip);
            }
            finally {
                ElementHelper.INSTANCE.setCurrentUid(null);
            }
        }
    }

    @Override
    public boolean shouldDisplay() {
        IWailaConfig.IConfigGeneral general = IWailaConfig.get().getGeneral();
        if (!general.getDisplayEntities()) {
            return false;
        }
        return general.getDisplayBosses() || !PlatformProxy.isBoss(this.entity);
    }

    @Override
    public void _requestData() {
        ClientPlatformProxy.requestEntityData(this.entity, this.showDetails());
    }

    @Override
    public boolean shouldRequestData() {
        return !WailaCommonRegistration.INSTANCE.getEntityNBTProviders(this.entity).isEmpty();
    }

    @Override
    public boolean _verifyData(class_2487 serverData) {
        if (!serverData.method_10545("WailaEntityID")) {
            return false;
        }
        return serverData.method_10550("WailaEntityID") == this.entity.method_5628();
    }

    @Override
    public Object getTarget() {
        return this.getEntity();
    }

    public static class Builder
    implements EntityAccessor.Builder {
        private class_1937 level;
        private class_1657 player;
        private class_2487 serverData;
        private boolean connected;
        public boolean showDetails;
        private class_3966 hit;
        private class_1297 entity;

        @Override
        public Builder level(class_1937 level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(class_1657 player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(class_2487 serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(class_3966 hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder entity(class_1297 entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder from(EntityAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = (class_3966)accessor.getHitResult();
            this.entity = accessor.getEntity();
            return this;
        }

        @Override
        public EntityAccessor build() {
            return new EntityAccessorImpl(this);
        }
    }
}

