/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import snownee.jade.gui.config.value.OptionValue;

public class InputOptionValue<T>
extends OptionValue<T> {
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?[0-9]+");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)");
    private final class_342 textField;
    private final Predicate<String> validator;

    public InputOptionValue(Runnable responder, String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        super(optionName, setter);
        this.value = value;
        this.validator = validator;
        this.textField = new class_342(this.client.field_1772, 0, 0, 98, 18, (class_2561)new class_2585(""));
        this.textField.method_1852(String.valueOf(value));
        this.textField.method_1863(s -> {
            if (this.validator.test((String)s)) {
                this.setValue((String)s);
                this.textField.method_1868(class_124.field_1068.method_532().intValue());
            } else {
                this.textField.method_1868(class_124.field_1061.method_532().intValue());
            }
            responder.run();
        });
    }

    @Override
    protected void drawValue(class_4587 matrixStack, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.method_16872(x);
        this.textField.field_22761 = y + entryHeight / 6;
        this.textField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public class_339 getListener() {
        return this.textField;
    }

    private void setValue(String text) {
        if (this.value instanceof String) {
            this.value = text;
        }
        try {
            if (this.value instanceof Integer) {
                this.value = Integer.valueOf(text);
            } else if (this.value instanceof Short) {
                this.value = Short.valueOf(text);
            } else if (this.value instanceof Byte) {
                this.value = Byte.valueOf(text);
            } else if (this.value instanceof Long) {
                this.value = Long.valueOf(text);
            } else if (this.value instanceof Double) {
                this.value = Double.valueOf(text);
            } else if (this.value instanceof Float) {
                this.value = Float.valueOf(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.save();
    }

    @Override
    public void setDisabled(boolean b) {
        super.setDisabled(b);
        this.textField.method_1888(!b);
    }

    @Override
    public boolean isValidValue() {
        return this.validator.test(this.textField.method_1882());
    }
}

