/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.text2speech.Narrator;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.event.WailaRayTraceEvent;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.gui.OptionsScreen;
import mcp.mobius.waila.impl.BlockAccessorImpl;
import mcp.mobius.waila.impl.EntityAccessorImpl;
import mcp.mobius.waila.impl.ObjectDataCenter;
import mcp.mobius.waila.impl.Tooltip;
import mcp.mobius.waila.impl.ui.TextElement;
import mcp.mobius.waila.overlay.DatapackBlockManager;
import mcp.mobius.waila.overlay.ProgressTracker;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.TooltipRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
public class WailaTickHandler {
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static Narrator narrator;
    private static String lastNarration;
    public TooltipRenderer tooltipRenderer = null;
    public ProgressTracker progressTracker = new ProgressTracker();

    public void tickClient() {
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Waila.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.tooltipRenderer = null;
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (!(client.f_91080_ instanceof OptionsScreen) && (client.m_91104_() || client.f_91080_ != null || client.f_91068_ == null)) {
            return;
        }
        ClientLevel world = client.f_91073_;
        LocalPlayer player = client.f_91074_;
        if (world == null || player == null) {
            this.tooltipRenderer = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        HitResult target = RayTracing.INSTANCE.getTarget();
        Tooltip currentTip = new Tooltip();
        Tooltip currentTipBody = new Tooltip();
        if (target == null || target.m_6662_() == HitResult.Type.MISS) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor<EntityHitResult> accessor = null;
        if (target instanceof BlockHitResult) {
            BlockHitResult blockTarget = (BlockHitResult)target;
            BlockState state = world.m_8055_(blockTarget.m_82425_());
            BlockEntity tileEntity = world.m_7702_(blockTarget.m_82425_());
            accessor = new BlockAccessorImpl(state, tileEntity, (Level)world, (Player)player, ObjectDataCenter.getServerData(), blockTarget, ObjectDataCenter.serverConnected, DatapackBlockManager.getFakeBlock((Level)world, blockTarget.m_82425_()));
        } else if (target instanceof EntityHitResult) {
            EntityHitResult entityTarget = (EntityHitResult)target;
            accessor = new EntityAccessorImpl(entityTarget.m_82443_(), (Level)world, (Player)player, ObjectDataCenter.getServerData(), entityTarget, ObjectDataCenter.serverConnected);
        }
        WailaRayTraceEvent event = new WailaRayTraceEvent(accessor, target);
        MinecraftForge.EVENT_BUS.post((Event)event);
        accessor = event.getAccessor();
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.tooltipRenderer = null;
            return;
        }
        if (!accessor.shouldDisplay()) {
            this.tooltipRenderer = null;
            return;
        }
        boolean showDetails = WailaClient.showDetails.m_90857_();
        if (accessor.isServerConnected()) {
            boolean request = accessor.shouldRequestData();
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    accessor._requestData(showDetails);
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        WailaTickHandler.gatherComponents(accessor, currentTip, TooltipPosition.HEAD);
        WailaTickHandler.gatherComponents(accessor, currentTipBody, TooltipPosition.BODY);
        if (config.getDisplayMode() == WailaConfig.DisplayMode.LITE && !currentTipBody.isEmpty() && !showDetails) {
            currentTip.sneakyDetails = true;
        } else {
            currentTip.lines.addAll(currentTipBody.lines);
        }
        WailaTickHandler.gatherComponents(accessor, currentTip, TooltipPosition.TAIL);
        this.tooltipRenderer = new TooltipRenderer(currentTip, true);
    }

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void gatherComponents(Accessor<?> accessor, Tooltip tooltip, TooltipPosition position) {
        accessor._setTooltipPosition(position);
        accessor._gatherComponents(tooltip);
        accessor._setTooltipPosition(null);
    }

    @SubscribeEvent
    public static void onTooltip(WailaTooltipEvent event) {
        if (event.getTooltip().isEmpty()) {
            return;
        }
        if (!WailaTickHandler.getNarrator().active() || !Waila.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91066_.f_92119_ != ChatVisiblity.HIDDEN) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46467_() % 5L > 0L) {
            return;
        }
        List<IElement> elements = event.getTooltip().get(CorePlugin.TAG_OBJECT_NAME);
        for (IElement element : elements) {
            if (!(element instanceof TextElement)) continue;
            String narrate = StringDecomposer.m_14326_((FormattedText)((TextElement)element).component);
            if (lastNarration.equalsIgnoreCase(narrate)) {
                return;
            }
            WailaTickHandler.getNarrator().clear();
            WailaTickHandler.getNarrator().say(narrate, true);
            lastNarration = narrate;
        }
    }

    static {
        lastNarration = "";
    }
}

