/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.config;

import com.google.common.collect.Maps;
import com.google.gson.annotations.Expose;
import java.util.Collection;
import java.util.Map;
import mcp.mobius.waila.api.config.HUDTheme;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.level.ClipContext;

public class WailaConfig {
    private final ConfigGeneral general = new ConfigGeneral();
    private final ConfigOverlay overlay = new ConfigOverlay();
    private final ConfigFormatting formatting = new ConfigFormatting();

    public ConfigGeneral getGeneral() {
        return this.general;
    }

    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    public static class ConfigGeneral {
        private boolean displayTooltip = true;
        private boolean displayBlocks = true;
        private boolean displayEntities = true;
        private DisplayMode displayMode = DisplayMode.TOGGLE;
        private boolean hideFromDebug = true;
        private IconMode iconMode = IconMode.TOP;
        private boolean enableTextToSpeech = false;
        private int maxHealthForRender = 40;
        private int maxHeartsPerLine = 10;
        private FluidMode fluidMode = FluidMode.NONE;
        private float reachDistance = 0.0f;
        @Expose
        private boolean debug = false;

        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        public boolean getDisplayEntities() {
            return this.displayEntities;
        }

        public boolean getDisplayBlocks() {
            return this.displayBlocks;
        }

        public void setDisplayBlocks(boolean displayBlocks) {
            this.displayBlocks = displayBlocks;
        }

        public void setDisplayEntities(boolean displayEntities) {
            this.displayEntities = displayEntities;
        }

        public void setDisplayMode(DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        public void setIconMode(IconMode iconMode) {
            this.iconMode = iconMode;
        }

        public void setEnableTextToSpeech(boolean enableTextToSpeech) {
            this.enableTextToSpeech = enableTextToSpeech;
        }

        public void setMaxHealthForRender(int maxHealthForRender) {
            this.maxHealthForRender = maxHealthForRender;
        }

        public void setMaxHeartsPerLine(int maxHeartsPerLine) {
            this.maxHeartsPerLine = maxHeartsPerLine;
        }

        public void setDisplayFluids(boolean displayFluids) {
            this.fluidMode = displayFluids ? FluidMode.ANY : FluidMode.NONE;
        }

        public void setDisplayFluids(FluidMode displayFluids) {
            this.fluidMode = displayFluids;
        }

        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        public DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public boolean shouldHideFromDebug() {
            return this.hideFromDebug;
        }

        public IconMode getIconMode() {
            return this.iconMode;
        }

        public boolean shouldShowIcon() {
            return this.iconMode != IconMode.HIDE;
        }

        public boolean shouldEnableTextToSpeech() {
            return this.enableTextToSpeech;
        }

        public int getMaxHealthForRender() {
            return this.maxHealthForRender;
        }

        public int getMaxHeartsPerLine() {
            return Math.max(1, this.maxHeartsPerLine);
        }

        public boolean shouldDisplayFluids() {
            return this.fluidMode != FluidMode.NONE;
        }

        public FluidMode getDisplayFluids() {
            return this.fluidMode;
        }

        public float getReachDistance() {
            return this.reachDistance;
        }

        public void setReachDistance(float reachDistance) {
            this.reachDistance = Mth.m_14036_((float)reachDistance, (float)0.0f, (float)20.0f);
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public static enum IconMode {
            TOP,
            CENTERED,
            HIDE;

        }
    }

    public static class ConfigOverlay {
        private float overlayPosX = 0.5f;
        private float overlayPosY = 1.0f;
        private float overlayScale = 1.0f;
        private float overlayAnchorX = 0.5f;
        private float overlayAnchorY = 0.0f;
        private boolean overlaySquare = false;
        private boolean flipMainHand = false;
        private ConfigOverlayColor color = new ConfigOverlayColor();
        @Expose
        private float autoScaleThreshold = 0.5f;

        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = Mth.m_14036_((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = Mth.m_14036_((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        public void setOverlayScale(float overlayScale) {
            this.overlayScale = Mth.m_14036_((float)overlayScale, (float)0.2f, (float)2.0f);
        }

        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = Mth.m_14036_((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = Mth.m_14036_((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        public float getOverlayPosX() {
            return Mth.m_14036_((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        public float getOverlayPosY() {
            return Mth.m_14036_((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        public float getOverlayScale() {
            return this.overlayScale;
        }

        public float getAnchorX() {
            return Mth.m_14036_((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        public float getAnchorY() {
            return Mth.m_14036_((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        public float tryFlip(float f) {
            if (Minecraft.m_91087_().f_91066_.f_92127_ == HumanoidArm.LEFT) {
                f = 1.0f - f;
            }
            return f;
        }

        public void setSquare(boolean overlaySquare) {
            this.overlaySquare = overlaySquare;
        }

        public boolean getSquare() {
            return this.overlaySquare;
        }

        public float getAutoScaleThreshold() {
            return this.autoScaleThreshold;
        }

        public ConfigOverlayColor getColor() {
            return this.color;
        }

        public static class ConfigOverlayColor {
            private float alpha = 0.7f;
            private Map<ResourceLocation, HUDTheme> themes = Maps.newLinkedHashMap();
            private ResourceLocation activeTheme;

            public ConfigOverlayColor() {
                this.activeTheme = HUDTheme.DARK.id;
                this.themes.put(HUDTheme.WAILA.id, HUDTheme.WAILA);
                this.themes.put(HUDTheme.DARK.id, HUDTheme.DARK);
                this.themes.put(HUDTheme.CREATE.id, HUDTheme.CREATE);
                this.themes.put(HUDTheme.TOP.id, HUDTheme.TOP);
            }

            public float getAlpha() {
                return this.alpha;
            }

            public HUDTheme getTheme() {
                return this.themes.getOrDefault(this.activeTheme, HUDTheme.DARK);
            }

            public Collection<HUDTheme> getThemes() {
                return this.themes.values();
            }

            public void setAlpha(float alpha) {
                this.alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
            }

            public int getBackgroundColor() {
                return ConfigOverlayColor.applyAlpha(this.getTheme().backgroundColor, this.getAlpha());
            }

            public int getGradientStart() {
                return ConfigOverlayColor.applyAlpha(this.getTheme().gradientStart, this.getAlpha());
            }

            public int getGradientEnd() {
                return ConfigOverlayColor.applyAlpha(this.getTheme().gradientEnd, this.getAlpha());
            }

            public static int applyAlpha(int color, float alpha) {
                int prevAlphaChannel = color >> 24 & 0xFF;
                if (prevAlphaChannel > 0) {
                    alpha *= (float)prevAlphaChannel / 256.0f;
                }
                int alphaChannel = (int)(255.0f * Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
                return color & 0xFFFFFF | alphaChannel << 24;
            }

            public void applyTheme(ResourceLocation id) {
                this.activeTheme = this.themes.containsKey(id) ? id : this.activeTheme;
            }

            public Style getTitle() {
                return ConfigOverlayColor.color(this.getTheme().titleColor);
            }

            private static Style color(int color) {
                return Style.f_131099_.m_178520_(color);
            }
        }
    }

    public static class ConfigFormatting {
        private String modName = "\u00a79\u00a7o%s";
        private String blockName = "%s";
        private String entityName = "%s";
        private String registryName = "\u00a77[%s]";

        public void setModName(String modName) {
            this.modName = modName;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public String getModName() {
            return this.modName;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getRegistryName() {
            return this.registryName;
        }
    }

    public static enum FluidMode {
        NONE(ClipContext.Fluid.NONE),
        ANY(ClipContext.Fluid.ANY),
        SOURCE_ONLY(ClipContext.Fluid.SOURCE_ONLY);

        public final ClipContext.Fluid ctx;

        private FluidMode(ClipContext.Fluid ctx) {
            this.ctx = ctx;
        }
    }

    public static enum DisplayMode {
        HOLD_KEY,
        TOGGLE,
        LITE;

    }
}

