/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import snownee.jade.util.PlatformProxy;

public class JsonConfig<T> {
    public static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().enableComplexMapKeySerialization().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setLenient().create();
    private final File configFile;
    private final CachedSupplier<T> configGetter;
    private Gson gson = DEFAULT_GSON;

    public JsonConfig(String fileName, Type configClass, @Nullable Runnable onUpdate, Supplier<T> defaultFactory) {
        this.configFile = new File(PlatformProxy.getConfigDirectory(), fileName + (fileName.endsWith(".json") ? "" : ".json"));
        this.configGetter = new CachedSupplier<Object>(() -> {
            Object object;
            if (!this.configFile.exists()) {
                Object def = defaultFactory.get();
                this.write(def, false);
                return def;
            }
            FileReader reader = new FileReader(this.configFile, StandardCharsets.UTF_8);
            try {
                Object ret2 = this.gson.fromJson((Reader)reader, configClass);
                if (ret2 == null) {
                    Object def = defaultFactory.get();
                    this.write(def, false);
                }
                object = ret2;
            }
            catch (Throwable ret2) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        ret2.addSuppressed(throwable);
                    }
                    throw ret2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        this.configFile.renameTo(new File(this.configFile.getPath() + ".invalid"));
                    }
                    catch (Exception ret2) {
                        // empty catch block
                    }
                    Object def = defaultFactory.get();
                    this.write(def, false);
                    return def;
                }
            }
            reader.close();
            return object;
        });
        this.configGetter.onUpdate = onUpdate;
    }

    public JsonConfig(String fileName, Class<T> configClass, @Nullable Runnable onUpdate) {
        this(fileName, configClass, onUpdate, () -> {
            try {
                return configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create new config instance", e);
            }
        });
    }

    public JsonConfig<T> withGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public T get() {
        return this.configGetter.get();
    }

    public void save() {
        this.write(this.get(), false);
    }

    public void write(T t, boolean invalidate) {
        if (!this.configFile.getParentFile().exists()) {
            this.configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(this.configFile, StandardCharsets.UTF_8);){
            writer.write(this.gson.toJson(t));
            if (invalidate) {
                this.invalidate();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void invalidate() {
        this.configGetter.invalidate();
    }

    public File getFile() {
        return this.configFile;
    }

    static class CachedSupplier<T> {
        private final Supplier<T> supplier;
        private T value;
        private Runnable onUpdate;

        public CachedSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (this.value == null) {
                CachedSupplier cachedSupplier = this;
                synchronized (cachedSupplier) {
                    this.value = this.supplier.get();
                    Objects.requireNonNull(this.value);
                    if (this.onUpdate != null) {
                        this.onUpdate.run();
                    }
                }
            }
            return this.value;
        }

        public void invalidate() {
            this.value = null;
        }
    }
}

