/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.text2speech.Narrator;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.RayTracing;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.util.ClientPlatformProxy;

public class WailaTickHandler {
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static Narrator narrator;
    private static String lastNarration;
    public TooltipRenderer tooltipRenderer = null;
    public ProgressTracker progressTracker = new ProgressTracker();

    public void tickClient() {
        Object blockTarget;
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.tooltipRenderer = null;
            return;
        }
        class_310 client = class_310.method_1551();
        if (!ClientPlatformProxy.shouldShowWithOverlay(client, client.field_1755)) {
            return;
        }
        if (client.field_1774 == null) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            this.tooltipRenderer = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        class_239 target = RayTracing.INSTANCE.getTarget();
        Tooltip tooltip = new Tooltip();
        if (target == null) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor<class_3966> accessor = null;
        class_239 class_2392 = target;
        if (class_2392 instanceof class_3965 && (blockTarget = (class_3965)class_2392).method_17783() != class_239.class_240.field_1333) {
            class_2680 class_26802 = world.method_8320(blockTarget.method_17777());
            class_2586 tileEntity = world.method_8321(blockTarget.method_17777());
            accessor = WailaClientRegistration.INSTANCE.blockAccessor().blockState(class_26802).blockEntity(tileEntity).hit((class_3965)blockTarget).build();
        } else {
            class_239 class_2393 = target;
            if (class_2393 instanceof class_3966) {
                class_3966 entityTarget = (class_3966)class_2393;
                accessor = WailaClientRegistration.INSTANCE.entityAccessor().hit(entityTarget).entity(entityTarget.method_17782()).build();
            }
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback jadeRayTraceCallback : WailaClientRegistration.INSTANCE.rayTraceCallback.callbacks()) {
            accessor = jadeRayTraceCallback.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.tooltipRenderer = null;
            return;
        }
        if (!accessor.shouldDisplay()) {
            this.tooltipRenderer = null;
            return;
        }
        if (accessor.isServerConnected()) {
            boolean request = accessor.shouldRequestData();
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    accessor._requestData();
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientPlatformProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            accessor._gatherComponents($ -> {
                if (Math.abs(WailaCommonRegistration.INSTANCE.priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            accessor._gatherComponents($ -> tooltip);
        }
        for (JadeTooltipCollectedCallback jadeTooltipCollectedCallback : WailaClientRegistration.INSTANCE.tooltipCollectedCallback.callbacks()) {
            jadeTooltipCollectedCallback.onTooltipCollected(tooltip, accessor);
        }
        this.tooltipRenderer = new TooltipRenderer(tooltip, true);
    }

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void narrate(ITooltip tooltip, boolean dedupe) {
        if (!WailaTickHandler.getNarrator().active() || tooltip.isEmpty()) {
            return;
        }
        String narration = tooltip.getMessage();
        if (dedupe && narration.equals(lastNarration)) {
            return;
        }
        Narrator narrator = WailaTickHandler.getNarrator();
        narrator.say(narration, true);
        lastNarration = narration;
    }

    static {
        lastNarration = "";
    }
}

