/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4587;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.FloatUnaryOperator;

public class SliderOptionValue
extends OptionValue<Float> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("^[0-9]*$");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)") || s.endsWith(".") || s.isEmpty();
    private final Slider slider;
    private float min;
    private float max;
    private FloatUnaryOperator aligner;

    public SliderOptionValue(String optionName, float value, Consumer<Float> save, float min, float max, FloatUnaryOperator aligner) {
        super(optionName, save);
        this.value = Float.valueOf(value);
        this.min = min;
        this.max = max;
        this.aligner = aligner;
        this.slider = new Slider(this, 0, 0, 100, 20, (class_2561)this.getTitle());
    }

    @Override
    protected void drawValue(class_4587 matrixStack, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.slider.field_22760 = x;
        this.slider.field_22761 = y + entryHeight / 6;
        this.slider.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public class_339 getListener() {
        return this.slider;
    }

    public static class Slider
    extends class_357 {
        private final SliderOptionValue parent;

        public Slider(SliderOptionValue parent, int x, int y, int width, int height, class_2561 message) {
            super(x, y, width, height, message, Slider.fromScaled(((Float)parent.value).floatValue(), parent.min, parent.max));
            this.parent = parent;
            this.method_25344();
        }

        public float toScaled() {
            return this.parent.aligner.apply(this.parent.min + (this.parent.max - this.parent.min) * (float)this.field_22753);
        }

        public static double fromScaled(float f, float min, float max) {
            return class_3532.method_15363((float)((f - min) / (max - min)), (float)0.0f, (float)1.0f);
        }

        protected void method_25346() {
            this.parent.value = Float.valueOf(this.toScaled());
            this.parent.save();
        }

        protected void method_25344() {
            this.method_25355((class_2561)new class_2585(DisplayHelper.dfCommas.format(this.toScaled())));
        }
    }
}

