/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.event.WailaRayTraceEvent;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.impl.config.PluginConfig;
import mcp.mobius.waila.overlay.DisplayHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.jade.VanillaPlugin;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class ClientHandler {
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;
    private static final Cache<BlockState, BlockState> CHEST_CACHE;

    @SubscribeEvent
    public static void post(WailaRenderEvent.Post event) {
        if (!PluginConfig.INSTANCE.get(VanillaPlugin.BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        MultiPlayerGameMode playerController = mc.f_91072_;
        if (playerController == null || playerController.f_105191_ == null) {
            return;
        }
        BlockState state = mc.f_91073_.m_8055_(playerController.f_105191_);
        if (playerController.m_105296_()) {
            canHarvest = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)mc.f_91074_);
        }
        int color = canHarvest ? 0xFFFFFF : 0xFF4444;
        Rect2i rect = event.getRect();
        int height = rect.m_110091_();
        int width = rect.m_110090_();
        if (!Waila.CONFIG.get().getOverlay().getSquare()) {
            --height;
            width -= 2;
        }
        progressAlpha += mc.m_91297_() * (playerController.m_105296_() ? 0.1f : -0.1f);
        if (playerController.m_105296_()) {
            progressAlpha = Math.min(progressAlpha, 0.53f);
            float progress = state.m_60625_((Player)mc.f_91074_, (BlockGetter)mc.f_91074_.f_19853_, playerController.f_105191_);
            if (playerController.f_105193_ + progress >= 1.0f) {
                progressAlpha = 1.0f;
            }
            progress = playerController.f_105193_ + mc.m_91296_() * progress;
            savedProgress = progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        color = WailaConfig.ConfigOverlay.ConfigOverlayColor.applyAlpha(color, progressAlpha);
        DisplayHelper.fill(event.getPoseStack(), 0.0f, (float)(height - 1), (float)width * savedProgress, (float)height, color);
    }

    private static BlockState getCorrespondingNormalChest(BlockState state) {
        try {
            return (BlockState)CHEST_CACHE.get((Object)state, () -> {
                ResourceLocation chestName;
                Block block;
                ResourceLocation trappedName = state.m_60734_().getRegistryName();
                if (trappedName.m_135815_().startsWith("trapped_") && (block = (Block)ForgeRegistries.BLOCKS.getValue(chestName = new ResourceLocation(trappedName.m_135827_(), trappedName.m_135815_().substring(8)))) != null) {
                    return ClientHandler.copyProperties(state, block.m_49966_());
                }
                return state;
            });
        }
        catch (Exception e) {
            return state;
        }
    }

    private static <T extends Comparable<T>> BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (!newState.m_61138_(property)) continue;
            newState = (BlockState)newState.m_61124_(property, (Comparable)property.m_61709_().cast(entry.getValue()));
        }
        return newState;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void override(WailaRayTraceEvent event) {
        Player player = event.getTarget().getPlayer();
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (event.getTarget() instanceof BlockAccessor) {
            BlockAccessor target = (BlockAccessor)event.getTarget();
            if (target.getBlock() instanceof TrappedChestBlock) {
                BlockState state = ClientHandler.getCorrespondingNormalChest(target.getBlockState());
                if (state != target.getBlockState()) {
                    event.setTarget(new BlockAccessor(state, target.getBlockEntity(), target.getLevel(), player, target.getServerData(), target.getHitResult(), target.isServerConnected()));
                }
            } else if (target.getBlock() instanceof InfestedBlock) {
                Block block = ((InfestedBlock)target.getBlock()).m_54192_();
                event.setTarget(new BlockAccessor(block.m_49966_(), target.getBlockEntity(), target.getLevel(), player, target.getServerData(), target.getHitResult(), target.isServerConnected()));
            } else if (target.getBlock() == Blocks.f_152499_) {
                Block block = Blocks.f_50127_;
                event.setTarget(new BlockAccessor(block.m_49966_(), null, target.getLevel(), player, target.getServerData(), target.getHitResult(), target.isServerConnected()));
            }
        }
    }

    static {
        CHEST_CACHE = CacheBuilder.newBuilder().build();
    }
}

