/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.forge;

import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.api.ui.IProgressStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import snownee.jade.VanillaPlugin;

public class ForgeCapabilityProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final ForgeCapabilityProvider INSTANCE = new ForgeCapabilityProvider();

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        block8: {
            IFluidHandler fluidHandler;
            IEnergyStorage storage;
            BlockEntity tile = accessor.getBlockEntity();
            if (tile == null) break block8;
            if (config.get(VanillaPlugin.FORGE_ENERGY) && (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY).orElse(null)) != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeEnergy"))) {
                int max;
                int cur;
                IElementHelper helper = tooltip.getElementHelper();
                if (accessor.isServerConnected()) {
                    cur = accessor.getServerData().m_128451_("jadeEnergy");
                    max = accessor.getServerData().m_128451_("jadeMaxEnergy");
                } else {
                    cur = storage.getEnergyStored();
                    max = storage.getMaxEnergyStored();
                }
                String curText = ChatFormatting.WHITE + VanillaPlugin.REGISTRAR.getDisplayHelper().humanReadableNumber(cur, "FE", false) + ChatFormatting.GRAY;
                String maxText = VanillaPlugin.REGISTRAR.getDisplayHelper().humanReadableNumber(max, "FE", false);
                MutableComponent text = new TranslatableComponent("jade.fe", new Object[]{curText, maxText}).m_130940_(ChatFormatting.GRAY);
                IProgressStyle progressStyle = helper.progressStyle().color(-65536, -10092544);
                tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, helper.borderStyle()).tag(VanillaPlugin.FORGE_ENERGY));
            }
            if (config.get(VanillaPlugin.FORGE_FLUID) && (fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null)) != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeTanks"))) {
                if (accessor.isServerConnected()) {
                    ListTag list = accessor.getServerData().m_128437_("jadeTanks", 10);
                    for (Tag nbt : list) {
                        CompoundTag tankData = (CompoundTag)nbt;
                        int capacity = tankData.m_128451_("capacity");
                        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tankData);
                        ForgeCapabilityProvider.appendTank(tooltip, fluidStack, capacity);
                    }
                } else {
                    for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                        ForgeCapabilityProvider.appendTank(tooltip, fluidHandler.getFluidInTank(i), fluidHandler.getTankCapacity(i));
                    }
                }
            }
        }
    }

    public static void appendTank(ITooltip tooltip, FluidStack fluidStack, int capacity) {
        TranslatableComponent text;
        if (capacity <= 0) {
            return;
        }
        IElementHelper helper = tooltip.getElementHelper();
        if (fluidStack.isEmpty()) {
            text = new TranslatableComponent("jade.fluid.empty");
        } else {
            String amountText = VanillaPlugin.REGISTRAR.getDisplayHelper().humanReadableNumber(fluidStack.getAmount(), "B", true);
            text = new TranslatableComponent("jade.fluid", new Object[]{fluidStack.getDisplayName(), amountText});
        }
        IProgressStyle progressStyle = helper.progressStyle().overlay(helper.fluid(fluidStack));
        tooltip.add(helper.progress((float)fluidStack.getAmount() / (float)capacity, (Component)text, progressStyle, helper.borderStyle()).tag(VanillaPlugin.FORGE_FLUID));
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity tile, boolean showDetails) {
        IFluidHandler fluidHandler;
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (storage != null) {
            data.m_128405_("jadeEnergy", storage.getEnergyStored());
            data.m_128405_("jadeMaxEnergy", storage.getMaxEnergyStored());
        }
        if ((fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null)) != null) {
            ListTag list = new ListTag();
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                int capacity = fluidHandler.getTankCapacity(i);
                if (capacity <= 0) continue;
                CompoundTag tankData = fluidHandler.getFluidInTank(i).writeToNBT(new CompoundTag());
                tankData.m_128405_("capacity", capacity);
                list.add((Object)tankData);
            }
            if (!list.isEmpty()) {
                data.m_128365_("jadeTanks", (Tag)list);
            }
        }
    }
}

