/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.gui.OptionsScreen;
import mcp.mobius.waila.impl.ObjectDataCenter;
import mcp.mobius.waila.impl.Tooltip;
import mcp.mobius.waila.overlay.DisplayHelper;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.TooltipRenderer;
import mcp.mobius.waila.overlay.WailaTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class OverlayRenderer {
    public static float ticks;

    public static void renderOverlay() {
        if (WailaTickHandler.instance().tooltipRenderer == null) {
            return;
        }
        if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        if (Waila.CONFIG.get().getGeneral().getDisplayMode() == WailaConfig.DisplayMode.HOLD_KEY && !WailaClient.showOverlay.m_90857_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget() == null) {
            return;
        }
        if (mc.f_91080_ != null) {
            if (!(mc.f_91080_ instanceof OptionsScreen)) {
                return;
            }
            Rect2i position = WailaTickHandler.instance().tooltipRenderer.getPosition();
            WailaConfig.ConfigOverlay overlay = Waila.CONFIG.get().getOverlay();
            Window window = mc.m_91268_();
            double x = mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            double y = mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_();
            if (position.m_110087_((int)(x += (double)((float)position.m_110090_() * overlay.tryFlip(overlay.getAnchorX()))), (int)(y += (double)((float)position.m_110091_() * overlay.getAnchorY())))) {
                return;
            }
        }
        if (mc.f_91065_.m_93088_().f_94524_ || mc.m_91265_() != null || mc.f_91066_.f_92062_) {
            return;
        }
        if (mc.f_91066_.f_92063_ && Waila.CONFIG.get().getGeneral().shouldHideFromDebug()) {
            return;
        }
        ticks += mc.m_91297_();
        if (RayTracing.INSTANCE.getTarget().m_6662_() != HitResult.Type.MISS) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltipRenderer, new PoseStack());
        }
    }

    public static void renderOverlay(TooltipRenderer tooltip, PoseStack matrixStack) {
        WailaRenderEvent.Pre preEvent;
        Minecraft.m_91087_().m_91307_().m_6180_("Waila Overlay");
        matrixStack.m_85836_();
        Rect2i position = tooltip.getPosition();
        WailaConfig.ConfigOverlay overlay = Waila.CONFIG.get().getOverlay();
        if (!overlay.getSquare()) {
            position.m_173056_(position.m_110090_() + 2);
            position.m_173058_(position.m_110091_() + 2);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(preEvent = new WailaRenderEvent.Pre(ObjectDataCenter.get(), position, matrixStack)))) {
            matrixStack.m_85849_();
            return;
        }
        position = preEvent.getRect();
        WailaConfig.ConfigOverlay configOverlay = Waila.CONFIG.get().getOverlay();
        if (!configOverlay.getSquare()) {
            position.m_173049_(position.m_110085_() + 1, position.m_110086_() + 1);
        }
        matrixStack.m_85837_((double)position.m_110085_(), (double)position.m_110086_(), 1.0);
        float scale = configOverlay.getOverlayScale();
        Window window = Minecraft.m_91087_().m_91268_();
        float thresholdHeight = (float)window.m_85446_() * configOverlay.getAutoScaleThreshold();
        if ((float)position.m_110091_() * scale > thresholdHeight) {
            scale = Math.max(scale * 0.5f, thresholdHeight / (float)position.m_110091_());
        }
        if (scale != 1.0f) {
            matrixStack.m_85841_(scale, scale, 1.0f);
        }
        matrixStack.m_85837_((double)((float)(-position.m_110090_()) * configOverlay.tryFlip(configOverlay.getAnchorX())), (double)((float)(-position.m_110091_()) * configOverlay.getAnchorY()), 0.0);
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
        if (color.getAlpha() > 0.0f) {
            WailaRenderEvent.Color colorEvent = new WailaRenderEvent.Color(color.getAlpha(), color.getBackgroundColor(), color.getGradientStart(), color.getGradientEnd());
            MinecraftForge.EVENT_BUS.post((Event)colorEvent);
            OverlayRenderer.drawTooltipBox(matrixStack, 0, 0, position.m_110090_(), position.m_110091_(), colorEvent.getBackground(), colorEvent.getGradientStart(), colorEvent.getGradientEnd(), Waila.CONFIG.get().getOverlay().getSquare());
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        tooltip.draw(matrixStack);
        RenderSystem.m_69461_();
        if (tooltip.hasIcon()) {
            Vec2 size = tooltip.icon.getCachedSize();
            Vec2 offset = tooltip.icon.getTranslation();
            float offsetY = Waila.CONFIG.get().getGeneral().getIconMode() == WailaConfig.ConfigGeneral.IconMode.TOP ? offset.f_82471_ + 2.0f : ((float)position.m_110091_() - size.f_82471_) / 2.0f - 1.0f;
            float offsetX = offset.f_82470_ + 5.0f;
            Tooltip.drawBorder(matrixStack, offsetX, offsetY, tooltip.icon);
            tooltip.icon.render(matrixStack, offsetX, offsetY, offsetX + size.f_82470_, offsetY + size.f_82471_);
        }
        WailaRenderEvent.Post postEvent = new WailaRenderEvent.Post(position, matrixStack);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        RenderSystem.m_69482_();
        matrixStack.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static void drawTooltipBox(PoseStack matrixStack, int x, int y, int w, int h, int bg, int grad1, int grad2, boolean square) {
        if (!square) {
            w -= 2;
            h -= 2;
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + 1, y + 1, w - 2, h - 2, bg, bg);
        if (!square) {
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y - 1, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x - 1, y, 1.0f, h, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w, y, 1.0f, h, bg, bg);
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w - 1, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y, w, 1.0f, grad1, grad1);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h - 1, w, 1.0f, grad2, grad2);
    }
}

