/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.impl.ui.ArmorElement;
import mcp.mobius.waila.impl.ui.HealthElement;
import mcp.mobius.waila.overlay.DisplayHelper;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;

public class BaseEntityProvider
implements IEntityComponentProvider {
    static final IEntityComponentProvider INSTANCE = new BaseEntityProvider();

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        TooltipPosition position = accessor.getTooltipPosition();
        if (position == TooltipPosition.HEAD) {
            this.appendHead(tooltip, accessor, config);
        } else if (position == TooltipPosition.BODY) {
            this.appendBody(tooltip, accessor, config);
        } else if (position == TooltipPosition.TAIL) {
            this.appendTail(tooltip, accessor, config);
        }
    }

    public void appendHead(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        String name = BaseEntityProvider.getEntityName(accessor.getEntity());
        WailaConfig wailaConfig = Waila.CONFIG.get();
        tooltip.add((Component)new TextComponent(String.format(wailaConfig.getFormatting().getEntityName(), name)).m_130948_(wailaConfig.getOverlay().getColor().getTitle()), CorePlugin.TAG_OBJECT_NAME);
        if (config.get(CorePlugin.CONFIG_REGISTRY_NAME)) {
            tooltip.add((Component)new TextComponent(accessor.getEntity().m_6095_().getRegistryName().toString()).m_130940_(ChatFormatting.GRAY), CorePlugin.TAG_REGISTRY_NAME);
        }
    }

    public static String getEntityName(Entity entity) {
        if (!entity.m_8077_()) {
            if (entity instanceof Villager) {
                return entity.m_6095_().m_20676_().getString();
            }
            if (entity instanceof ItemEntity) {
                return ((ItemEntity)entity).m_32055_().m_41786_().getString();
            }
        }
        return entity.m_7755_().getString();
    }

    public void appendBody(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!(accessor.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (config.get(CorePlugin.CONFIG_ENTITY_HEALTH)) {
            this.appendHealth((LivingEntity)accessor.getEntity(), tooltip);
        }
        if (config.get(CorePlugin.CONFIG_ENTITY_HEALTH)) {
            this.appendArmor((LivingEntity)accessor.getEntity(), tooltip);
        }
    }

    public void appendTail(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!config.get(CorePlugin.CONFIG_MOD_NAME)) {
            return;
        }
        tooltip.add((Component)new TextComponent(String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModName(accessor.getEntity()))));
    }

    private void appendHealth(LivingEntity living, ITooltip tooltip) {
        float health = living.m_21223_();
        float maxHealth = living.m_21233_();
        if (living.m_21233_() > (float)Waila.CONFIG.get().getGeneral().getMaxHealthForRender()) {
            HealthElement icon = new HealthElement(1.0f, 1.0f);
            TextComponent text = new TextComponent(String.format("  %s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth)));
            tooltip.add(icon);
            tooltip.append((Component)text);
        } else {
            tooltip.add(new HealthElement(maxHealth * 0.5f, health * 0.5f));
        }
    }

    private void appendArmor(LivingEntity living, ITooltip tooltip) {
        float armor = living.m_21230_();
        if (armor == 0.0f) {
            return;
        }
        if (armor > (float)Waila.CONFIG.get().getGeneral().getMaxHealthForRender()) {
            ArmorElement icon = new ArmorElement(-1.0f);
            TextComponent text = new TextComponent(DisplayHelper.dfCommas.format(armor));
            tooltip.add(icon);
            tooltip.append((Component)text);
        } else {
            tooltip.add(new ArmorElement(armor * 0.5f));
        }
    }
}

