/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.command.DumpHandlersCommand;
import mcp.mobius.waila.impl.WailaRegistrar;
import mcp.mobius.waila.impl.config.PluginConfig;
import mcp.mobius.waila.network.ReceiveDataPacket;
import mcp.mobius.waila.network.RequestEntityPacket;
import mcp.mobius.waila.network.RequestTilePacket;
import mcp.mobius.waila.network.ServerPingPacket;
import mcp.mobius.waila.utils.JsonConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="waila")
public class Waila {
    public static final String MODID = "waila";
    public static final String NAME = "Waila";
    public static final Logger LOGGER = LogManager.getLogger((String)"Waila");
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("waila", "networking")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final JsonConfig<WailaConfig> CONFIG = new JsonConfig<WailaConfig>("jade/jade", WailaConfig.class).withGson(new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create());

    public Waila() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::playerJoin);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        NETWORK.registerMessage(0, ReceiveDataPacket.class, ReceiveDataPacket::write, ReceiveDataPacket::read, ReceiveDataPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(1, ServerPingPacket.class, ServerPingPacket::write, ServerPingPacket::read, ServerPingPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(2, RequestEntityPacket.class, RequestEntityPacket::write, RequestEntityPacket::read, RequestEntityPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        NETWORK.registerMessage(3, RequestTilePacket.class, RequestTilePacket::write, RequestTilePacket::read, RequestTilePacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent event) {
        WailaClient.initClient();
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        List classNames = ModList.get().getAllScanData().stream().flatMap($ -> $.getAnnotations().stream()).filter($ -> {
            String required;
            return $.annotationType().getClassName().equals(WailaPlugin.class.getName()) && ((required = $.annotationData().getOrDefault("value", "")).isEmpty() || ModList.get().isLoaded(required));
        }).sorted((a, b) -> Integer.compare(Waila.getPriority(a), Waila.getPriority(b))).map(ModFileScanData.AnnotationData::memberName).collect(Collectors.toList());
        for (String className : classNames) {
            LOGGER.info("Start loading plugin at {}", (Object)className);
            try {
                Class<?> clazz = Class.forName(className);
                if (!IWailaPlugin.class.isAssignableFrom(clazz)) continue;
                IWailaPlugin plugin = (IWailaPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.register(WailaRegistrar.INSTANCE);
            }
            catch (Throwable e) {
                LOGGER.error("Error loading plugin at {}", (Object)className, (Object)e);
            }
        }
        PluginConfig.INSTANCE.reload();
    }

    private static int getPriority(ModFileScanData.AnnotationData data) {
        return data.annotationData().getOrDefault("priority", 0);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        DumpHandlersCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.info("Syncing config to {} ({})", (Object)event.getPlayer().m_36316_().getName(), (Object)event.getPlayer().m_36316_().getId());
        NETWORK.sendTo((Object)new ServerPingPacket(PluginConfig.INSTANCE), ((ServerPlayer)event.getPlayer()).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

