/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.forge;

import java.lang.invoke.MethodHandles;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yalter.mousetweaks.ConfigScreen;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.Main;
import yalter.mousetweaks.MouseButton;

@Mod(value="mousetweaks")
public class MouseTweaksForge {
    public MouseTweaksForge() {
        Main.initialize();
        BusGroup.DEFAULT.register(MethodHandles.lookup(), (Object)this);
        MinecraftForge.registerConfigScreen(ConfigScreen::new);
    }

    @SubscribeEvent
    public boolean onGuiMouseClickedPre(ScreenEvent.MouseButtonPressed.Pre event) {
        Logger.DebugLog("onGuiMouseClickedPre button = " + event.getButton());
        MouseButton button = MouseButton.fromEventButton(event.getButton());
        return button != null && Main.onMouseClicked(event.getScreen(), event.getMouseX(), event.getMouseY(), button);
    }

    @SubscribeEvent
    public boolean onGuiMouseReleasedPre(ScreenEvent.MouseButtonReleased.Pre event) {
        Logger.DebugLog("onGuiMouseReleasedPre button = " + event.getButton());
        MouseButton button = MouseButton.fromEventButton(event.getButton());
        return button != null && Main.onMouseReleased(event.getScreen(), event.getMouseX(), event.getMouseY(), button);
    }

    @SubscribeEvent
    public void onGuiMouseScrollPost(ScreenEvent.MouseScrolled.Post event) {
        Logger.DebugLog("onGuiMouseScrollPost delta = " + event.getDeltaY());
        Main.onMouseScrolled(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getDeltaY());
    }

    @SubscribeEvent
    public boolean onGuiMouseDragPre(ScreenEvent.MouseDragged.Pre event) {
        Logger.DebugLog("onGuiMouseDragPre button = " + event.getMouseButton() + ", dx = " + event.getDragX() + ", dy = " + event.getDragY());
        MouseButton button = MouseButton.fromEventButton(event.getMouseButton());
        return button != null && Main.onMouseDrag(event.getScreen(), event.getMouseX(), event.getMouseY(), button);
    }
}

