/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.forge;

import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yalter.mousetweaks.ConfigScreen;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.Main;
import yalter.mousetweaks.MouseButton;

@Mod(value="mousetweaks")
public class MouseTweaksForge {
    public MouseTweaksForge() {
        Main.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.registerConfigScreen(ConfigScreen::new);
    }

    @SubscribeEvent
    public void onGuiMouseClickedPre(ScreenEvent.MouseButtonPressed.Pre event) {
        Logger.DebugLog("onGuiMouseClickedPre button = " + event.getButton());
        MouseButton button = MouseButton.fromEventButton(event.getButton());
        if (button != null && Main.onMouseClicked(event.getScreen(), event.getMouseX(), event.getMouseY(), button)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseReleasedPre(ScreenEvent.MouseButtonReleased.Pre event) {
        Logger.DebugLog("onGuiMouseReleasedPre button = " + event.getButton());
        MouseButton button = MouseButton.fromEventButton(event.getButton());
        if (button != null && Main.onMouseReleased(event.getScreen(), event.getMouseX(), event.getMouseY(), button)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseScrollPost(ScreenEvent.MouseScrolled.Post event) {
        Logger.DebugLog("onGuiMouseScrollPost delta = " + event.getDeltaY());
        Main.onMouseScrolled(event.getScreen(), event.getMouseX(), event.getMouseY(), event.getDeltaY());
    }

    @SubscribeEvent
    public void onGuiMouseDragPre(ScreenEvent.MouseDragged.Pre event) {
        Logger.DebugLog("onGuiMouseDragPre button = " + event.getMouseButton() + ", dx = " + event.getDragX() + ", dy = " + event.getDragY());
        MouseButton button = MouseButton.fromEventButton(event.getMouseButton());
        if (button != null && Main.onMouseDrag(event.getScreen(), event.getMouseX(), event.getMouseY(), button)) {
            event.setCanceled(true);
        }
    }
}

