/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import yalter.mousetweaks.Constants;
import yalter.mousetweaks.IGuiScreenHandler;
import yalter.mousetweaks.MouseButton;
import yalter.mousetweaks.Reflection;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;
import yalter.mousetweaks.api.MouseTweaksIgnore;

public class GuiContainerHandler
implements IGuiScreenHandler {
    Minecraft mc = Minecraft.m_91087_();
    private AbstractContainerScreen guiContainer;
    private Method handleMouseClick;

    public GuiContainerHandler(AbstractContainerScreen guiContainer) {
        this.guiContainer = guiContainer;
        this.handleMouseClick = Reflection.getHMCMethod(guiContainer);
    }

    @Override
    public boolean isMouseTweaksDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksIgnore.class) || Reflection.guiContainerClass == null;
    }

    @Override
    public boolean isWheelTweakDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksDisableWheelTweak.class);
    }

    @Override
    public List<Slot> getSlots() {
        return this.guiContainer.m_6262_().f_38839_;
    }

    @Override
    public Slot getSlotUnderMouse(double mouseX, double mouseY) {
        try {
            return (Slot)Reflection.guiContainerClass.invokeMethod(this.guiContainer, Constants.GETSELECTEDSLOT_NAME.forgeName, mouseX, mouseY);
        }
        catch (InvocationTargetException e) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)e, (String)"GuiContainer.getSlotAtPosition() threw an exception when called from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public boolean disableRMBDraggingFunctionality() {
        Reflection.guiContainerClass.setFieldValue(this.guiContainer, Constants.IGNOREMOUSEUP_NAME.forgeName, true);
        if (((Boolean)Reflection.guiContainerClass.getFieldValue(this.guiContainer, Constants.DRAGSPLITTING_NAME.forgeName)).booleanValue() && (Integer)Reflection.guiContainerClass.getFieldValue(this.guiContainer, Constants.DRAGSPLITTINGBUTTON_NAME.forgeName) == 1) {
            Reflection.guiContainerClass.setFieldValue(this.guiContainer, Constants.DRAGSPLITTING_NAME.forgeName, false);
            return true;
        }
        return false;
    }

    @Override
    public void clickSlot(Slot slot, MouseButton mouseButton, boolean shiftPressed) {
        try {
            this.handleMouseClick.invoke((Object)this.guiContainer, slot, slot.f_40219_, mouseButton.getValue(), shiftPressed ? ClickType.QUICK_MOVE : ClickType.PICKUP);
        }
        catch (InvocationTargetException e) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)e, (String)"handleMouseClick() threw an exception when called from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
        catch (IllegalAccessException e) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)e, (String)"Calling handleMouseClick() from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public boolean isCraftingOutput(Slot slot) {
        return slot instanceof ResultSlot || slot instanceof FurnaceResultSlot || slot instanceof MerchantResultSlot;
    }

    @Override
    public boolean isIgnored(Slot slot) {
        return false;
    }
}

