/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.fluid.fabric;

import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public enum FluidStackImpl implements FluidStack.FluidStackAdapter<Pair>
{
    INSTANCE;

    public static Function<FluidStack, Object> toValue;
    public static Function<Object, FluidStack> fromValue;

    public static FluidStack.FluidStackAdapter<Object> adapt(Function<FluidStack, Object> toValue, Function<Object, FluidStack> fromValue) {
        FluidStackImpl.toValue = toValue;
        FluidStackImpl.fromValue = fromValue;
        return INSTANCE;
    }

    @Override
    public Pair create(Supplier<class_3611> fluid, long amount, class_2487 tag) {
        class_3611 fluidType = Objects.requireNonNull(fluid).get();
        if (fluidType instanceof class_3609) {
            class_3609 flowingFluid = (class_3609)fluidType;
            fluidType = flowingFluid.method_15751();
        }
        return new Pair(FluidVariant.of((class_3611)fluidType, (class_2487)(tag == null ? null : tag.method_10553())), amount);
    }

    @Override
    public Supplier<class_3611> getRawFluidSupplier(Pair object) {
        return () -> ((FluidVariant)object.variant).getFluid();
    }

    @Override
    public class_3611 getFluid(Pair object) {
        return object.variant.getFluid();
    }

    @Override
    public long getAmount(Pair object) {
        return object.amount;
    }

    @Override
    public void setAmount(Pair object, long amount) {
        object.amount = amount;
    }

    @Override
    public class_2487 getTag(Pair value) {
        return value.variant.getNbt();
    }

    @Override
    public void setTag(Pair value, class_2487 tag) {
        value.variant = FluidVariant.of((class_3611)value.variant.getFluid(), (class_2487)tag);
    }

    @Override
    public Pair copy(Pair value) {
        return new Pair(FluidVariant.of((class_3611)value.variant.getFluid(), (class_2487)value.variant.copyNbt()), value.amount);
    }

    @Override
    public int hashCode(Pair value) {
        Pair pair = value;
        int code = 1;
        code = 31 * code + pair.variant.getFluid().hashCode();
        code = 31 * code + Long.hashCode(pair.amount);
        class_2487 tag = pair.variant.getNbt();
        if (tag != null) {
            code = 31 * code + tag.hashCode();
        }
        return code;
    }

    public static class Pair {
        public FluidVariant variant;
        public long amount;

        public Pair(FluidVariant variant, long amount) {
            this.variant = variant;
            this.amount = amount;
        }
    }
}

