/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.trade.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.shedaniel.architectury.registry.trade.VillagerTradeOfferContext;
import me.shedaniel.architectury.registry.trade.WanderingTraderOfferContext;
import net.minecraft.class_3852;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TradeRegistryData {
    public static final List<Consumer<VillagerTradeOfferContext>> VILLAGER_MODIFY_HANDLERS = new ArrayList<Consumer<VillagerTradeOfferContext>>();
    public static final List<Predicate<VillagerTradeOfferContext>> VILLAGER_REMOVE_HANDLERS = new ArrayList<Predicate<VillagerTradeOfferContext>>();
    public static final List<Consumer<WanderingTraderOfferContext>> WANDERING_TRADER_MODIFY_HANDLERS = new ArrayList<Consumer<WanderingTraderOfferContext>>();
    public static final List<Predicate<WanderingTraderOfferContext>> WANDERING_TRADER_REMOVE_HANDLERS = new ArrayList<Predicate<WanderingTraderOfferContext>>();
    public static final Map<class_3852, Map<Integer, Integer>> VILLAGER_MAX_OFFER_OVERRIDES = new HashMap<class_3852, Map<Integer, Integer>>();
    public static Integer wanderingTraderMaxOfferOverride = null;

    @Nullable
    public static Integer getVillagerMaxOffers(class_3852 profession, int level) {
        if (!VILLAGER_MAX_OFFER_OVERRIDES.containsKey(profession)) {
            return null;
        }
        return VILLAGER_MAX_OFFER_OVERRIDES.get(profession).get(level);
    }

    @Nullable
    public static Integer getWanderingTraderMaxOffers() {
        return wanderingTraderMaxOfferOverride;
    }

    public static boolean invokeVillagerOfferRemoving(VillagerTradeOfferContext ctx) {
        return VILLAGER_REMOVE_HANDLERS.stream().anyMatch(predicate -> predicate.test(ctx));
    }

    public static void invokeVillagerOfferModify(VillagerTradeOfferContext ctx) {
        VILLAGER_MODIFY_HANDLERS.forEach(consumer -> consumer.accept(ctx));
    }

    public static boolean invokeWanderingTraderOfferRemoving(WanderingTraderOfferContext ctx) {
        return WANDERING_TRADER_REMOVE_HANDLERS.stream().anyMatch(predicate -> predicate.test(ctx));
    }

    public static void invokeWanderingTraderOfferModify(WanderingTraderOfferContext ctx) {
        WANDERING_TRADER_MODIFY_HANDLERS.forEach(consumer -> consumer.accept(ctx));
    }
}

