/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.platform.fabric;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.shedaniel.architectury.platform.Mod;
import me.shedaniel.architectury.utils.Env;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformImpl {
    public static final Map<String, Mod.ConfigurationScreenProvider> CONFIG_SCREENS = new ConcurrentHashMap<String, Mod.ConfigurationScreenProvider>();
    private static final Map<String, Mod> mods = new ConcurrentHashMap<String, Mod>();

    public static Path getGameFolder() {
        return FabricLoader.getInstance().getGameDir().toAbsolutePath().normalize();
    }

    public static Path getConfigFolder() {
        return FabricLoader.getInstance().getConfigDir().toAbsolutePath().normalize();
    }

    public static Path getModsFolder() {
        return PlatformImpl.getGameFolder().resolve("mods");
    }

    public static Env getEnvironment() {
        return Env.fromPlatform(PlatformImpl.getEnv());
    }

    public static EnvType getEnv() {
        return FabricLoader.getInstance().getEnvironmentType();
    }

    public static boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    public static Mod getMod(String id) {
        return mods.computeIfAbsent(id, ModImpl::new);
    }

    public static Collection<Mod> getMods() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            PlatformImpl.getMod(mod.getMetadata().getId());
        }
        return mods.values();
    }

    public static Collection<String> getModIds() {
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(ModMetadata::getId).collect(Collectors.toList());
    }

    public static boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    private static class ModImpl
    implements Mod {
        private final ModContainer container;
        private final ModMetadata metadata;

        public ModImpl(String id) {
            this.container = (ModContainer)FabricLoader.getInstance().getModContainer(id).orElseThrow(() -> new NoSuchElementException("No value present"));
            this.metadata = this.container.getMetadata();
        }

        @Override
        @NotNull
        public String getModId() {
            return this.metadata.getId();
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.metadata.getVersion().getFriendlyString();
        }

        @Override
        @NotNull
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.metadata.getDescription();
        }

        @Override
        @NotNull
        public Optional<String> getLogoFile(int preferredSize) {
            return this.metadata.getIconPath(preferredSize);
        }

        @Override
        public List<Path> getFilePaths() {
            return this.container.getRootPaths();
        }

        @Override
        @NotNull
        public Path getFilePath() {
            return this.container.getRootPath();
        }

        @Override
        @NotNull
        public Collection<String> getAuthors() {
            return this.metadata.getAuthors().stream().map(Person::getName).collect(Collectors.toList());
        }

        @Override
        @Nullable
        public Collection<String> getLicense() {
            return this.metadata.getLicense();
        }

        @Override
        @NotNull
        public Optional<String> getHomepage() {
            return this.metadata.getContact().get("homepage");
        }

        @Override
        @NotNull
        public Optional<String> getSources() {
            return this.metadata.getContact().get("issues");
        }

        @Override
        @NotNull
        public Optional<String> getIssueTracker() {
            return this.metadata.getContact().get("sources");
        }

        @Override
        public void registerConfigurationScreen(Mod.ConfigurationScreenProvider provider) {
            if (CONFIG_SCREENS.containsKey(this.getModId())) {
                throw new IllegalStateException("Can not register configuration screen for mod '" + this.getModId() + "' because it was already registered!");
            }
            CONFIG_SCREENS.put(this.getModId(), provider);
        }
    }
}

