/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking.transformers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.transformers.PacketTransformer;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.architectury.utils.EnvExecutor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class SplitPacketTransformer
implements PacketTransformer {
    private static final Logger LOGGER = LogManager.getLogger(SplitPacketTransformer.class);
    private static final byte START = 0;
    private static final byte PART = 1;
    private static final byte END = 2;
    private static final byte ONLY = 3;
    private final Map<PartKey, PartData> cache = Collections.synchronizedMap(new HashMap());

    public SplitPacketTransformer() {
        PlayerEvent.PLAYER_QUIT.register(player -> this.cache.keySet().removeIf(key -> Objects.equals(((PartKey)key).playerUUID, player.method_5667())));
        EnvExecutor.runInEnv(Env.CLIENT, () -> () -> SplitPacketTransformer.lambda$new$2(new Client()));
    }

    @Override
    public void inbound(NetworkManager.Side side, class_2960 id, class_2540 buf, NetworkManager.PacketContext context, PacketTransformer.TransformationSink sink) {
        PartKey key = side == NetworkManager.Side.S2C ? new PartKey(side, null) : new PartKey(side, context.getPlayer().method_5667());
        switch (buf.readByte()) {
            case 0: {
                PartData data = new PartData(id, buf.readInt());
                if (this.cache.put(key, data) != null) {
                    LOGGER.warn("Received invalid START packet for SplitPacketTransformer with packet id " + id + " for side " + (Object)((Object)side));
                }
                buf.retain();
                data.parts.add(buf);
                break;
            }
            case 1: {
                PartData data = this.cache.get(key);
                if (data == null) {
                    LOGGER.warn("Received invalid PART packet for SplitPacketTransformer with packet id " + id + " for side " + (Object)((Object)side));
                    buf.release();
                    break;
                }
                if (!data.id.equals((Object)id)) {
                    LOGGER.warn("Received invalid PART packet for SplitPacketTransformer with packet id " + id + " for side " + (Object)((Object)side) + ", id in cache is " + data.id);
                    buf.release();
                    for (class_2540 part : data.parts) {
                        if (part == buf) continue;
                        part.release();
                    }
                    this.cache.remove(key);
                    break;
                }
                buf.retain();
                data.parts.add(buf);
                break;
            }
            case 2: {
                PartData data = this.cache.get(key);
                if (data == null) {
                    LOGGER.warn("Received invalid END packet for SplitPacketTransformer with packet id " + id + " for side " + (Object)((Object)side));
                    buf.release();
                } else if (!data.id.equals((Object)id)) {
                    LOGGER.warn("Received invalid END packet for SplitPacketTransformer with packet id " + id + " for side " + (Object)((Object)side) + ", id in cache is " + data.id);
                    buf.release();
                    for (class_2540 part : data.parts) {
                        if (part == buf) continue;
                        part.release();
                    }
                    this.cache.remove(key);
                } else {
                    buf.retain();
                    data.parts.add(buf);
                }
                if (data.parts.size() != data.partsExpected) {
                    LOGGER.warn("Received invalid END packet for SplitPacketTransformer with packet id " + id + " for side " + (Object)((Object)side) + " with size " + data.parts + ", parts expected is " + data.partsExpected);
                    for (class_2540 part : data.parts) {
                        if (part == buf) continue;
                        part.release();
                    }
                } else {
                    class_2540 byteBuf = new class_2540(Unpooled.wrappedBuffer((ByteBuf[])data.parts.toArray(new ByteBuf[0])));
                    sink.accept(side, data.id, byteBuf);
                    byteBuf.release();
                }
                this.cache.remove(key);
                break;
            }
            case 3: {
                sink.accept(side, id, buf);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal split packet header!");
            }
        }
    }

    @Override
    public void outbound(NetworkManager.Side side, class_2960 id, class_2540 buf, PacketTransformer.TransformationSink sink) {
        int maxSize = (side == NetworkManager.Side.C2S ? Short.MAX_VALUE : 0x100000) - 1 - 10;
        if (buf.readableBytes() <= maxSize) {
            ByteBuf stateBuf = Unpooled.buffer((int)1);
            stateBuf.writeByte(3);
            class_2540 packetBuffer = new class_2540(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{stateBuf, buf}));
            sink.accept(side, id, packetBuffer);
        } else {
            int partSize = maxSize - 4;
            int parts = Math.round((float)buf.readableBytes() / (float)partSize);
            for (int i = 0; i < parts; ++i) {
                class_2540 packetBuffer = new class_2540(Unpooled.buffer());
                if (i == 0) {
                    packetBuffer.writeByte(0);
                    packetBuffer.writeInt(parts);
                } else if (i == parts - 1) {
                    packetBuffer.writeByte(2);
                } else {
                    packetBuffer.writeByte(1);
                }
                int next = Math.min(buf.readableBytes(), partSize);
                packetBuffer.writeBytes(buf.retainedSlice(buf.readerIndex(), next));
                buf.skipBytes(next);
                sink.accept(side, id, packetBuffer);
            }
            buf.release();
        }
    }

    private static /* synthetic */ void lambda$new$2(Client rec$) {
        rec$.init();
    }

    private static class PartKey {
        private final NetworkManager.Side side;
        @Nullable
        private final UUID playerUUID;

        public PartKey(NetworkManager.Side side, @Nullable UUID playerUUID) {
            this.side = side;
            this.playerUUID = playerUUID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartKey)) {
                return false;
            }
            PartKey key = (PartKey)o;
            return this.side == key.side && Objects.equals(this.playerUUID, key.playerUUID);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.side, this.playerUUID});
        }

        public String toString() {
            return "PartKey{side=" + (Object)((Object)this.side) + ", playerUUID=" + this.playerUUID + '}';
        }
    }

    private static class PartData {
        private final class_2960 id;
        private final int partsExpected;
        private final List<class_2540> parts;

        public PartData(class_2960 id, int partsExpected) {
            this.id = id;
            this.partsExpected = partsExpected;
            this.parts = new ArrayList<class_2540>();
        }
    }

    private class Client {
        private Client() {
        }

        @Environment(value=EnvType.CLIENT)
        private void init() {
            ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> SplitPacketTransformer.this.cache.keySet().removeIf(key -> ((PartKey)key).side == NetworkManager.Side.S2C));
        }
    }
}

