/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collections;
import java.util.List;
import me.shedaniel.architectury.networking.fabric.NetworkManagerImpl;
import me.shedaniel.architectury.networking.transformers.PacketCollector;
import me.shedaniel.architectury.networking.transformers.PacketSink;
import me.shedaniel.architectury.networking.transformers.PacketTransformer;
import me.shedaniel.architectury.networking.transformers.SinglePacketCollector;
import me.shedaniel.architectury.utils.Env;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkManager {
    public static void registerReceiver(Side side, class_2960 id, NetworkReceiver receiver) {
        NetworkManager.registerReceiver(side, id, Collections.emptyList(), receiver);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, class_2960 id, List<PacketTransformer> packetTransformers, NetworkReceiver receiver) {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManagerImpl.registerReceiver(side, (class_2960)var1_1, (List<PacketTransformer>)var2_2, (NetworkReceiver)var3_3);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static class_2596<?> toPacket(Side side, class_2960 id, class_2540 buf) {
        SinglePacketCollector sink = new SinglePacketCollector(null);
        NetworkManager.collectPackets(sink, side, id, buf);
        return sink.getPacket();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static List<class_2596<?>> toPackets(Side side, class_2960 id, class_2540 buf) {
        PacketCollector sink = new PacketCollector(null);
        NetworkManager.collectPackets(sink, side, id, buf);
        return sink.collect();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void collectPackets(PacketSink sink, Side side, class_2960 id, class_2540 buf) {
        void var3_3;
        void var2_2;
        void var1_1;
        NetworkManagerImpl.collectPackets(sink, (Side)var1_1, (class_2960)var2_2, (class_2540)var3_3);
    }

    public static void sendToPlayer(class_3222 player, class_2960 id, class_2540 buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayer(player), NetworkManager.serverToClient(), id, buf);
    }

    public static void sendToPlayers(Iterable<class_3222> players, class_2960 id, class_2540 buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayers(players), NetworkManager.serverToClient(), id, buf);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(class_2960 id, class_2540 buf) {
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), id, buf);
    }

    @Environment(value=EnvType.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(class_2960 id) {
        return NetworkManagerImpl.canServerReceive(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(class_3222 player, class_2960 id) {
        void var1_1;
        return NetworkManagerImpl.canPlayerReceive(player, (class_2960)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2596<?> createAddEntityPacket(class_1297 entity) {
        return NetworkManagerImpl.createAddEntityPacket(entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(class_2540 var1, PacketContext var2);
    }

    public static interface PacketContext {
        public class_1657 getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public EnvType getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }
}

