/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.hooks.biome;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import me.shedaniel.architectury.hooks.biome.BiomeProperties;
import me.shedaniel.architectury.hooks.biome.ClimateProperties;
import me.shedaniel.architectury.hooks.biome.EffectsProperties;
import me.shedaniel.architectury.hooks.biome.GenerationProperties;
import me.shedaniel.architectury.hooks.biome.SpawnProperties;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2975;
import net.minecraft.class_3414;
import net.minecraft.class_3504;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5312;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import org.jetbrains.annotations.Nullable;

public final class BiomeHooks {
    public static BiomeProperties getBiomeProperties(class_1959 biome) {
        return new BiomeWrapped(biome);
    }

    public static class BiomeWrapped
    implements BiomeProperties {
        protected final class_1959 biome;
        protected final ClimateProperties climateProperties;
        protected final EffectsProperties effectsProperties;
        protected final GenerationProperties generationProperties;
        protected final SpawnProperties spawnProperties;

        public BiomeWrapped(class_1959 biome) {
            this(biome, new ClimateWrapped(biome), new EffectsWrapped(biome), new GenerationSettingsWrapped(biome), new SpawnSettingsWrapped(biome));
        }

        public BiomeWrapped(class_1959 biome, ClimateProperties climateProperties, EffectsProperties effectsProperties, GenerationProperties generationProperties, SpawnProperties spawnProperties) {
            this.biome = biome;
            this.climateProperties = climateProperties;
            this.effectsProperties = effectsProperties;
            this.generationProperties = generationProperties;
            this.spawnProperties = spawnProperties;
        }

        @Override
        public ClimateProperties getClimateProperties() {
            return this.climateProperties;
        }

        @Override
        public EffectsProperties getEffectsProperties() {
            return this.effectsProperties;
        }

        @Override
        public GenerationProperties getGenerationProperties() {
            return this.generationProperties;
        }

        @Override
        public SpawnProperties getSpawnProperties() {
            return this.spawnProperties;
        }

        @Override
        public class_1959.class_1961 getCategory() {
            return this.biome.field_9329;
        }

        @Override
        public float getDepth() {
            return this.biome.field_9343;
        }

        @Override
        public float getScale() {
            return this.biome.field_9341;
        }
    }

    public static class SpawnSettingsWrapped
    implements SpawnProperties {
        protected final class_5483 settings;

        public SpawnSettingsWrapped(class_1959 biome) {
            this(biome.method_30966());
        }

        public SpawnSettingsWrapped(class_5483 settings) {
            this.settings = settings;
        }

        @Override
        public float getCreatureProbability() {
            return this.settings.method_31002();
        }

        @Override
        public Map<class_1311, List<class_5483.class_1964>> getSpawners() {
            return null;
        }

        @Override
        public Map<class_1299<?>, class_5483.class_5265> getMobSpawnCosts() {
            return null;
        }

        @Override
        public boolean isPlayerSpawnFriendly() {
            return this.settings.method_31082();
        }
    }

    public static class GenerationSettingsWrapped
    implements GenerationProperties {
        protected final class_5485 settings;

        public GenerationSettingsWrapped(class_1959 biome) {
            this(biome.method_30970());
        }

        public GenerationSettingsWrapped(class_5485 settings) {
            this.settings = settings;
        }

        @Override
        public Optional<Supplier<class_3504<?>>> getSurfaceBuilder() {
            return Optional.ofNullable(this.settings.method_30984());
        }

        @Override
        public List<Supplier<class_2922<?>>> getCarvers(class_2893.class_2894 carving) {
            return this.settings.method_30976(carving);
        }

        @Override
        public List<Supplier<class_2975<?, ?>>> getFeatures(class_2893.class_2895 decoration) {
            if (decoration.ordinal() >= this.settings.method_30983().size()) {
                return Collections.emptyList();
            }
            return (List)this.settings.method_30983().get(decoration.ordinal());
        }

        @Override
        public List<List<Supplier<class_2975<?, ?>>>> getFeatures() {
            return this.settings.method_30983();
        }

        @Override
        public List<Supplier<class_5312<?, ?>>> getStructureStarts() {
            return (List)this.settings.method_30975();
        }
    }

    public static class EffectsWrapped
    implements EffectsProperties.Mutable {
        protected final class_4763 effects;

        public EffectsWrapped(class_1959 biome) {
            this(biome.method_24377());
        }

        public EffectsWrapped(class_4763 effects) {
            this.effects = effects;
        }

        @Override
        public EffectsProperties.Mutable setFogColor(int color) {
            this.effects.field_22067 = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterColor(int color) {
            this.effects.field_22068 = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterFogColor(int color) {
            this.effects.field_22069 = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setSkyColor(int color) {
            this.effects.field_26418 = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setFoliageColorOverride(@Nullable Integer colorOverride) {
            this.effects.field_26419 = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorOverride(@Nullable Integer colorOverride) {
            this.effects.field_26420 = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorModifier(class_4763.class_5486 modifier) {
            this.effects.field_26421 = modifier;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientParticle(@Nullable class_4761 settings) {
            this.effects.field_22070 = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientLoopSound(@Nullable class_3414 sound) {
            this.effects.field_22491 = Optional.ofNullable(sound);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientMoodSound(@Nullable class_4968 settings) {
            this.effects.field_22492 = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientAdditionsSound(@Nullable class_4967 settings) {
            this.effects.field_22493 = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setBackgroundMusic(@Nullable class_5195 music) {
            this.effects.field_24113 = Optional.ofNullable(music);
            return this;
        }

        @Override
        public int getFogColor() {
            return this.effects.field_22067;
        }

        @Override
        public int getWaterColor() {
            return this.effects.field_22068;
        }

        @Override
        public int getWaterFogColor() {
            return this.effects.field_22069;
        }

        @Override
        public int getSkyColor() {
            return this.effects.field_26418;
        }

        @Override
        public OptionalInt getFoliageColorOverride() {
            return this.effects.field_26419.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public OptionalInt getGrassColorOverride() {
            return this.effects.field_26420.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public class_4763.class_5486 getGrassColorModifier() {
            return this.effects.field_26421;
        }

        @Override
        public Optional<class_4761> getAmbientParticle() {
            return this.effects.field_22070;
        }

        @Override
        public Optional<class_3414> getAmbientLoopSound() {
            return this.effects.field_22491;
        }

        @Override
        public Optional<class_4968> getAmbientMoodSound() {
            return this.effects.field_22492;
        }

        @Override
        public Optional<class_4967> getAmbientAdditionsSound() {
            return this.effects.field_22493;
        }

        @Override
        public Optional<class_5195> getBackgroundMusic() {
            return this.effects.field_24113;
        }
    }

    public static class ClimateWrapped
    implements ClimateProperties.Mutable {
        protected final class_1959.class_5482 climateSettings;

        public ClimateWrapped(class_1959 biome) {
            this(biome.field_26393);
        }

        public ClimateWrapped(class_1959.class_5482 climateSettings) {
            this.climateSettings = climateSettings;
        }

        @Override
        public ClimateProperties.Mutable setPrecipitation(class_1959.class_1963 precipitation) {
            this.climateSettings.field_26399 = precipitation;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperature(float temperature) {
            this.climateSettings.field_26400 = temperature;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperatureModifier(class_1959.class_5484 temperatureModifier) {
            this.climateSettings.field_26401 = temperatureModifier;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setDownfall(float downfall) {
            this.climateSettings.field_26402 = downfall;
            return this;
        }

        @Override
        public class_1959.class_1963 getPrecipitation() {
            return this.climateSettings.field_26399;
        }

        @Override
        public float getTemperature() {
            return this.climateSettings.field_26400;
        }

        @Override
        public class_1959.class_5484 getTemperatureModifier() {
            return this.climateSettings.field_26401;
        }

        @Override
        public float getDownfall() {
            return this.climateSettings.field_26402;
        }
    }

    public static class MutableBiomeWrapped
    extends BiomeWrapped
    implements BiomeProperties.Mutable {
        public MutableBiomeWrapped(class_1959 biome, GenerationProperties.Mutable generationProperties, SpawnProperties.Mutable spawnProperties) {
            this(biome, new ClimateWrapped(biome.field_26393), new EffectsWrapped(biome.method_24377()), generationProperties, spawnProperties);
        }

        public MutableBiomeWrapped(class_1959 biome, ClimateProperties.Mutable climateProperties, EffectsProperties.Mutable effectsProperties, GenerationProperties.Mutable generationProperties, SpawnProperties.Mutable spawnProperties) {
            super(biome, climateProperties, effectsProperties, generationProperties, spawnProperties);
        }

        @Override
        public ClimateProperties.Mutable getClimateProperties() {
            return (ClimateProperties.Mutable)super.getClimateProperties();
        }

        @Override
        public EffectsProperties.Mutable getEffectsProperties() {
            return (EffectsProperties.Mutable)super.getEffectsProperties();
        }

        @Override
        public GenerationProperties.Mutable getGenerationProperties() {
            return (GenerationProperties.Mutable)super.getGenerationProperties();
        }

        @Override
        public SpawnProperties.Mutable getSpawnProperties() {
            return (SpawnProperties.Mutable)super.getSpawnProperties();
        }

        @Override
        public BiomeProperties.Mutable setCategory(class_1959.class_1961 category) {
            this.biome.field_9329 = category;
            return this;
        }

        @Override
        public BiomeProperties.Mutable setDepth(float depth) {
            this.biome.field_9343 = depth;
            return this;
        }

        @Override
        public BiomeProperties.Mutable setScale(float scale) {
            this.biome.field_9341 = scale;
            return this;
        }
    }
}

