/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public interface GeoRenderer<T extends GeoAnimatable, O, R extends GeoRenderState> {
    public GeoModel<T> getGeoModel();

    default public List<GeoRenderLayer<T, O, R>> getRenderLayers() {
        return List.of();
    }

    @ApiStatus.Internal
    default public long getInstanceId(T animatable, O relatedObject) {
        return animatable.hashCode();
    }

    default public int getRenderColor(T animatable, O relatedObject, float partialTick) {
        return -1;
    }

    default public int getPackedOverlay(T animatable, O relatedObject, float u, float partialTick) {
        return OverlayTexture.NO_OVERLAY;
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public ResourceLocation getTextureLocation(R renderState) {
        return this.getGeoModel().getTextureResource((GeoRenderState)renderState);
    }

    @Nullable
    default public RenderType getRenderType(R renderState, ResourceLocation texture) {
        return this.getGeoModel().getRenderType((GeoRenderState)renderState, texture);
    }

    @ApiStatus.OverrideOnly
    default public void addRenderData(T animatable, O relatedObject, R renderState) {
    }

    @ApiStatus.Internal
    default public R captureDefaultRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        long instanceId = this.getInstanceId(animatable, relatedObject);
        renderState.addGeckolibData(DataTickets.TICK, animatable.getTick(relatedObject));
        renderState.addGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, instanceId);
        renderState.addGeckolibData(DataTickets.ANIMATABLE_MANAGER, animatable.getAnimatableInstanceCache().getManagerForId(instanceId));
        renderState.addGeckolibData(DataTickets.PARTIAL_TICK, (Float)Float.valueOf(partialTick));
        renderState.addGeckolibData(DataTickets.RENDER_COLOR, this.getRenderColor(animatable, relatedObject, partialTick));
        renderState.addGeckolibData(DataTickets.PACKED_OVERLAY, this.getPackedOverlay(animatable, relatedObject, 0.0f, partialTick));
        renderState.addGeckolibData(DataTickets.IS_MOVING, false);
        renderState.addGeckolibData(DataTickets.BONE_RESET_TIME, animatable.getBoneResetTime());
        renderState.addGeckolibData(DataTickets.ANIMATABLE_CLASS, animatable.getClass());
        renderState.addGeckolibData(DataTickets.PER_BONE_TASKS, (Reference2ObjectOpenHashMap)new Reference2ObjectOpenHashMap(0));
        return renderState;
    }

    @ApiStatus.Internal
    default public R fillRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        this.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        this.addRenderData(animatable, relatedObject, renderState);
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.addRenderData(animatable, relatedObject, renderState);
        }
        this.fireCompileRenderStateEvent(animatable, relatedObject, renderState);
        this.getGeoModel().prepareForRenderPass(animatable, (GeoRenderState)renderState);
        return renderState;
    }

    default public void defaultRender(R renderState, PoseStack poseStack, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer) {
        poseStack.pushPose();
        if (renderType == null) {
            renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
        }
        if (buffer == null && renderType != null) {
            buffer = bufferSource.getBuffer(renderType);
        }
        GeoModel<T> geoModel = this.getGeoModel();
        BakedGeoModel model = geoModel.getBakedModel(geoModel.getModelResource((GeoRenderState)renderState));
        int packedOverlay = renderState.getGeckolibData(DataTickets.PACKED_OVERLAY);
        int packedLight = renderState.getGeckolibData(DataTickets.PACKED_LIGHT);
        int renderColor = renderState.getGeckolibData(DataTickets.RENDER_COLOR);
        this.preRender(renderState, poseStack, model, bufferSource, buffer, false, packedLight, packedOverlay, renderColor);
        this.adjustPositionForRender(renderState, poseStack, model, false);
        this.scaleModelForRender(renderState, 1.0f, 1.0f, poseStack, model, false);
        if (this.firePreRenderEvent(renderState, poseStack, model, bufferSource)) {
            this.preApplyRenderLayers(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
            this.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, false, packedLight, packedOverlay, renderColor);
            this.applyRenderLayers(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
            this.postRender(renderState, poseStack, model, bufferSource, buffer, false, packedLight, packedOverlay, renderColor);
            this.firePostRenderEvent(renderState, poseStack, model, bufferSource);
        }
        poseStack.popPose();
        this.renderFinal(renderState, poseStack, model, bufferSource, buffer, packedLight, packedOverlay, renderColor);
        this.doPostRenderCleanup();
    }

    default public void reRender(R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, RenderType renderType, VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        poseStack.pushPose();
        this.preRender(renderState, poseStack, model, bufferSource, buffer, true, packedLight, packedOverlay, renderColor);
        this.adjustPositionForRender(renderState, poseStack, model, true);
        this.scaleModelForRender(renderState, 1.0f, 1.0f, poseStack, model, true);
        this.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, true, packedLight, packedOverlay, renderColor);
        this.postRender(renderState, poseStack, model, bufferSource, buffer, true, packedLight, packedOverlay, renderColor);
        poseStack.popPose();
    }

    default public void actuallyRender(R renderState, PoseStack poseStack, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (renderType == null || buffer == null) {
            return;
        }
        for (GeoBone group : model.topLevelBones()) {
            this.renderRecursively(renderState, poseStack, group, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
    }

    default public void preApplyRenderLayers(R renderState, PoseStack poseStack, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        Reference2ObjectMap perBoneTasks = this.getPerBoneTasks(renderState);
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
            renderLayer.addPerBoneRender(renderState, model, (boneName, renderOp) -> perBoneTasks.put(boneName, (Object)Pair.of((Object)new MutableObject(), (Object)renderOp)));
        }
    }

    default public void applyRenderLayers(R renderState, PoseStack poseStack, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        for (Reference2ObjectMap.Entry entry : this.getPerBoneTasks(renderState).reference2ObjectEntrySet()) {
            ((PerBoneRender)((Pair)entry.getValue()).right()).runTask(renderState, poseStack, (GeoBone)entry.getKey(), (PoseStack.Pose)((MutableObject)((Pair)entry.getValue()).left()).getValue(), renderType, bufferSource, packedLight, packedOverlay, renderColor);
        }
        for (GeoRenderLayer geoRenderLayer : this.getRenderLayers()) {
            geoRenderLayer.render(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
        }
    }

    default public void preRender(R renderState, PoseStack poseStack, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void postRender(R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void renderFinal(R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void doPostRenderCleanup() {
    }

    default public void renderRecursively(R renderState, PoseStack poseStack, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        Pair boneRenderTask;
        poseStack.pushPose();
        RenderUtil.prepMatrixForBone(poseStack, bone);
        if (!isReRender && (boneRenderTask = (Pair)this.getPerBoneTasks(renderState).get((Object)bone)) != null) {
            ((MutableObject)boneRenderTask.left()).setValue((Object)poseStack.last().copy());
        }
        this.renderCubesOfBone(renderState, bone, poseStack, buffer, packedLight, packedOverlay, renderColor);
        this.renderChildBones(renderState, bone, poseStack, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        poseStack.popPose();
    }

    default public void renderCubesOfBone(R renderState, GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.getCubes()) {
            poseStack.pushPose();
            this.renderCube(renderState, cube, poseStack, buffer, packedLight, packedOverlay, renderColor);
            poseStack.popPose();
        }
    }

    default public void renderChildBones(R renderState, GeoBone bone, PoseStack poseStack, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, int packedLight, int packedColor, int renderColor) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (GeoBone childBone : bone.getChildBones()) {
            this.renderRecursively(renderState, poseStack, childBone, renderType, bufferSource, buffer, isReRender, packedLight, packedColor, renderColor);
        }
    }

    default public void renderCube(R renderState, GeoCube cube, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        RenderUtil.translateToPivotPoint(poseStack, cube);
        RenderUtil.rotateMatrixAroundCube(poseStack, cube);
        RenderUtil.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.last().normal();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtil.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(renderState, quad, poseState, normal, buffer, packedOverlay, packedLight, renderColor);
        }
    }

    default public void createVerticesOfQuad(R renderState, GeoQuad quad, Matrix4f poseState, Vector3f normal, VertexConsumer buffer, int packedOverlay, int packedLight, int renderColor) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.addVertex(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    default public void adjustPositionForRender(R renderState, PoseStack poseStack, BakedGeoModel model, boolean isReRender) {
    }

    default public void scaleModelForRender(R renderState, float widthScale, float heightScale, PoseStack poseStack, BakedGeoModel model, boolean isReRender) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            poseStack.scale(widthScale, heightScale, widthScale);
        }
    }

    default public AnimationState<T> createAnimationState(R renderState) {
        return new AnimationState((GeoRenderState)renderState);
    }

    default public void setBonesVisible(boolean visible, String ... boneNames) {
        GeoModel<T> model = this.getGeoModel();
        for (String boneName : boneNames) {
            model.getBone(boneName).ifPresent(bone -> bone.setHidden(!visible));
        }
    }

    default public void setBonesVisible(boolean visible, GeoBone ... bones) {
        if (bones == null) {
            return;
        }
        for (GeoBone bone : bones) {
            if (bone == null) continue;
            bone.setHidden(!visible);
        }
    }

    public void fireCompileRenderLayersEvent();

    public void fireCompileRenderStateEvent(T var1, O var2, R var3);

    public boolean firePreRenderEvent(R var1, PoseStack var2, BakedGeoModel var3, MultiBufferSource var4);

    public void firePostRenderEvent(R var1, PoseStack var2, BakedGeoModel var3, MultiBufferSource var4);

    default public Reference2ObjectMap<GeoBone, Pair<MutableObject<PoseStack.Pose>, PerBoneRender<R>>> getPerBoneTasks(R renderState) {
        return renderState.getGeckolibData(DataTickets.PER_BONE_TASKS);
    }
}

