/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.platform;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.service.GeckoLibClient;

public final class GeckoLibClientForge
implements GeckoLibClient {
    @Override
    @NotNull
    public <S extends HumanoidRenderState> HumanoidModel<?> getArmorModelForItem(S entityRenderState, ItemStack stack, EquipmentSlot slot, EquipmentClientInfo.LayerType type, HumanoidModel<S> defaultModel) {
        HumanoidModel humanoidModel;
        GeoArmorRenderer<?, ?> geoArmorRenderer;
        Item item = stack.getItem();
        HumanoidModel model = IClientItemExtensions.of((Item)item).getHumanoidArmorModel(entityRenderState, stack, slot, defaultModel);
        if (model == defaultModel && (geoArmorRenderer = GeoRenderProvider.of(item).getGeoArmorRenderer(entityRenderState, stack, slot, type, defaultModel)) instanceof GeoArmorRenderer) {
            GeoArmorRenderer<?, ?> geoArmorRenderer2 = geoArmorRenderer;
            return geoArmorRenderer2;
        }
        return model instanceof HumanoidModel ? (humanoidModel = model) : defaultModel;
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForItem(ItemStack item) {
        GeoItemRenderer<?> geoItemRenderer = GeoRenderProvider.of(item).getGeoItemRenderer();
        if (geoItemRenderer instanceof GeoRenderer) {
            GeoItemRenderer<?> geoRenderer = geoItemRenderer;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForArmor(ItemStack armour, EquipmentSlot slot, EquipmentClientInfo.LayerType type) {
        HumanoidModel defaultModel = slot == EquipmentSlot.LEGS ? (HumanoidModel)GENERIC_INNER_ARMOR_MODEL.get() : (HumanoidModel)GENERIC_OUTER_ARMOR_MODEL.get();
        GeoArmorRenderer<?, ?> geoArmorRenderer = IClientItemExtensions.of((ItemStack)armour).getHumanoidArmorModel(new LivingEntityRenderState(), armour, slot, defaultModel);
        if (geoArmorRenderer instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = geoArmorRenderer;
            return armorRenderer.getGeoModel();
        }
        geoArmorRenderer = GeoRenderProvider.of(armour).getGeoArmorRenderer(null, armour, slot, type, defaultModel);
        if (geoArmorRenderer instanceof GeoArmorRenderer) {
            GeoArmorRenderer<?, ?> armorRenderer = geoArmorRenderer;
            return armorRenderer.getGeoModel();
        }
        return null;
    }

    @Override
    public int getDyedItemColor(ItemStack itemStack, int defaultColor) {
        return itemStack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)itemStack, (int)defaultColor) : defaultColor;
    }
}

