/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.cache.SyncedSingletonAnimatableCache;
import software.bernie.geckolib.network.packet.MultiloaderPacket;

public record SingletonAnimTriggerPacket(String syncableId, long instanceId, Optional<String> controllerName, String animName) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<SingletonAnimTriggerPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("singleton_anim_trigger"));
    public static final StreamCodec<FriendlyByteBuf, SingletonAnimTriggerPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SingletonAnimTriggerPacket::syncableId, (StreamCodec)ByteBufCodecs.VAR_LONG, SingletonAnimTriggerPacket::instanceId, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), SingletonAnimTriggerPacket::controllerName, (StreamCodec)ByteBufCodecs.STRING_UTF8, SingletonAnimTriggerPacket::animName, SingletonAnimTriggerPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            AnimatableManager animatableManager;
            GeoAnimatable animatable = SyncedSingletonAnimatableCache.getSyncedAnimatable(this.syncableId);
            if (animatable != null && (animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(this.instanceId)) != null) {
                animatableManager.tryTriggerAnimation(this.controllerName.orElse(null), this.animName);
            }
        });
    }
}

