/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math.function.round;

import net.minecraft.util.Mth;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.function.MathFunction;

public final class LerpFunction
extends MathFunction {
    private final MathValue min;
    private final MathValue max;
    private final MathValue delta;

    public LerpFunction(MathValue ... values) {
        super(values);
        this.min = values[0];
        this.max = values[1];
        this.delta = values[2];
    }

    @Override
    public String getName() {
        return "math.lerp";
    }

    @Override
    public double compute(AnimationState<?> animationState) {
        return Mth.lerp((double)this.delta.get(animationState), (double)this.min.get(animationState), (double)this.max.get(animationState));
    }

    @Override
    public int getMinArgs() {
        return 3;
    }

    @Override
    public MathValue[] getArgs() {
        return new MathValue[]{this.min, this.max, this.delta};
    }
}

