/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;

public final class RenderUtil {
    public static void translateMatrixToBone(PoseStack poseStack, GeoBone bone) {
        poseStack.translate(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(PoseStack poseStack, GeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.mulPose(Axis.ZP.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.mulPose(Axis.YP.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.mulPose(Axis.XP.rotation(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(PoseStack poseStack, GeoCube cube) {
        Vec3 rotation = cube.rotation();
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.z()));
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, (float)rotation.y(), 0.0f));
        poseStack.mulPose(new Quaternionf().rotationXYZ((float)rotation.x(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(PoseStack poseStack, GeoBone bone) {
        poseStack.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(pivot.x() / 16.0, pivot.y() / 16.0, pivot.z() / 16.0);
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoBone bone) {
        poseStack.translate(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(-pivot.x() / 16.0, -pivot.y() / 16.0, -pivot.z() / 16.0);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoBone bone) {
        poseStack.translate(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, GeoBone bone) {
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(PoseStack poseStack, GeoBone bone) {
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(PoseStack poseStack, Entity animatable, float partialTick) {
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    @Nullable
    public static IntIntPair getTextureDimensions(ResourceLocation texture) {
        if (texture == null) {
            return null;
        }
        AbstractTexture originalTexture = null;
        Minecraft mc = Minecraft.getInstance();
        try {
            originalTexture = (AbstractTexture)mc.submit(() -> mc.getTextureManager().getTexture(texture)).get();
        }
        catch (Exception e) {
            GeckoLibConstants.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        NativeImage image = null;
        try {
            NativeImage nativeImage;
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                nativeImage = dynamicTexture.getPixels();
            } else {
                nativeImage = NativeImage.read((InputStream)((Resource)mc.getResourceManager().getResource(texture).get()).open());
            }
            image = nativeImage;
        }
        catch (Exception e) {
            GeckoLibConstants.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.getWidth(), (int)image.getHeight());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return Blaze3D.getTime() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static Vec3 arrayToVec(double[] array) {
        return new Vec3(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(ModelPart from, GeoBone to) {
        to.updateRotation(-from.xRot, -from.yRot, from.zRot);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().y() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().x() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().x() == 0.0 || cube.size().y() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> 90.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    public static double lerpYaw(double delta, double start, double end) {
        double diff = (start = Mth.wrapDegrees((double)start)) - (end = Mth.wrapDegrees((double)end));
        end = diff > 180.0 || diff < -180.0 ? start + Math.copySign(360.0 - Math.abs(diff), diff) : end;
        return Mth.lerp((double)delta, (double)start, (double)end);
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntityType(EntityType<?> entityType) {
        GeoModel geoModel;
        Object v = Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(entityType);
        if (v instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)v;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoAnimatable getReplacedAnimatable(EntityType<?> entityType) {
        GeoAnimatable geoAnimatable;
        Object v = Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(entityType);
        if (v instanceof GeoReplacedEntityRenderer) {
            GeoReplacedEntityRenderer replacedEntityRenderer = (GeoReplacedEntityRenderer)v;
            geoAnimatable = (GeoAnimatable)replacedEntityRenderer.getAnimatable();
        } else {
            geoAnimatable = null;
        }
        return geoAnimatable;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntity(Entity entity) {
        GeoModel geoModel;
        EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entity);
        if (entityRenderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)entityRenderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForItem(ItemStack item) {
        return GeckoLibServices.Client.ITEM_RENDERING.getGeoModelForItem(item);
    }

    @Nullable
    public static GeoModel<?> getGeoModelForBlock(BlockEntity blockEntity) {
        GeoModel geoModel;
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForArmor(ItemStack stack, EquipmentSlot slot, EquipmentClientInfo.LayerType type) {
        return GeckoLibServices.Client.ITEM_RENDERING.getGeoModelForArmor(stack, slot, type);
    }

    public static void prepLivingEntityRenderState(LivingEntity entity, LivingEntityRenderState entityRenderState, float partialTick, ItemModelResolver itemModelResolver) {
        BlockItem headItem;
        Minecraft minecraft = Minecraft.getInstance();
        float yHeadRot = Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        ItemStack headStack = entity.getItemBySlot(EquipmentSlot.HEAD);
        entityRenderState.bodyRot = LivingEntityRenderer.solveBodyRot((LivingEntity)entity, (float)yHeadRot, (float)partialTick);
        entityRenderState.yRot = Mth.wrapDegrees((float)(yHeadRot - entityRenderState.bodyRot));
        entityRenderState.xRot = entity.getXRot(partialTick);
        entityRenderState.customName = entity.getCustomName();
        entityRenderState.isUpsideDown = LivingEntityRenderer.isEntityUpsideDown((LivingEntity)entity);
        if (entityRenderState.isUpsideDown) {
            entityRenderState.xRot *= -1.0f;
            entityRenderState.yRot *= -1.0f;
        }
        if (!entity.isPassenger() && entity.isAlive()) {
            entityRenderState.walkAnimationPos = entity.walkAnimation.position(partialTick);
            entityRenderState.walkAnimationSpeed = entity.walkAnimation.speed(partialTick);
        } else {
            entityRenderState.walkAnimationPos = 0.0f;
            entityRenderState.walkAnimationSpeed = 0.0f;
        }
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingVehicle = (LivingEntity)entity2;
            entityRenderState.wornHeadAnimationPos = livingVehicle.walkAnimation.position(partialTick);
        } else {
            entityRenderState.wornHeadAnimationPos = entityRenderState.walkAnimationPos;
        }
        entityRenderState.scale = entity.getScale();
        entityRenderState.ageScale = entity.getAgeScale();
        entityRenderState.pose = entity.getPose();
        entityRenderState.bedOrientation = entity.getBedOrientation();
        if (entityRenderState.bedOrientation != null) {
            entityRenderState.eyeHeight = entity.getEyeHeight(Pose.STANDING);
        }
        entityRenderState.isFullyFrozen = entity.isFullyFrozen();
        entityRenderState.isBaby = entity.isBaby();
        entityRenderState.isInWater = entity.isInWater();
        entityRenderState.isAutoSpinAttack = entity.isAutoSpinAttack();
        entityRenderState.hasRedOverlay = entity.hurtTime > 0 || entity.deathTime > 0;
        Item item = headStack.getItem();
        if (item instanceof BlockItem && (item = (headItem = (BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            entityRenderState.wornHeadType = skullBlock.getType();
            entityRenderState.wornHeadProfile = (ResolvableProfile)headStack.get(DataComponents.PROFILE);
            entityRenderState.headItem.clear();
        } else {
            entityRenderState.wornHeadType = null;
            entityRenderState.wornHeadProfile = null;
            if (!HumanoidArmorLayer.shouldRender((ItemStack)headStack, (EquipmentSlot)EquipmentSlot.HEAD)) {
                itemModelResolver.updateForLiving(entityRenderState.headItem, headStack, ItemDisplayContext.HEAD, false, entity);
            } else {
                entityRenderState.headItem.clear();
            }
        }
        entityRenderState.deathTime = entity.deathTime > 0 ? (float)entity.deathTime + partialTick : 0.0f;
        entityRenderState.isInvisibleToPlayer = entityRenderState.isInvisible && entity.isInvisibleTo((Player)minecraft.player);
        entityRenderState.appearsGlowing = minecraft.shouldEntityAppearGlowing((Entity)entity);
    }
}

