/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.object.Color;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

@ApiStatus.Internal
public class InternalUtil {
    public static <E extends LivingEntity, S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>> boolean tryRenderGeoArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, E entity, ItemStack stack, EquipmentSlot equipmentSlot, M parentModel, A baseModel, float partialTick, int packedLight, float netHeadYaw, float headPitch, BiConsumer<A, EquipmentSlot> partVisibilitySetter) {
        Item item = stack.getItem();
        Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
        if (equippable == null || equippable.slot() != equipmentSlot) {
            return false;
        }
        HumanoidModel<?> geckolibModel = GeoRenderProvider.of(item).getGeoArmorRenderer(entity, stack, equipmentSlot, equipmentSlot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID, baseModel);
        if (geckolibModel == null) {
            return false;
        }
        parentModel.copyPropertiesTo(baseModel);
        partVisibilitySetter.accept(baseModel, equipmentSlot);
        if (geckolibModel instanceof GeoArmorRenderer) {
            GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)geckolibModel;
            geoArmorRenderer.prepForRender((Entity)entity, stack, equipmentSlot, baseModel, bufferSource, partialTick, netHeadYaw, headPitch);
        }
        baseModel.copyPropertiesTo(geckolibModel);
        geckolibModel.renderToBuffer(poseStack, null, packedLight, OverlayTexture.NO_OVERLAY, Color.WHITE.argbInt());
        return true;
    }
}

