/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.resource;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.util.ARGB;

public record GeoGlowingTextureMeta(List<Pixel> pixels) {
    public static final Codec<GeoGlowingTextureMeta> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Pixel.FROM_REGION_CODEC.listOf().comapFlatMap(pixelsLists -> {
        ImmutableList.Builder pixelsBuilder = ImmutableList.builder();
        pixelsLists.forEach(arg_0 -> ((ImmutableList.Builder)pixelsBuilder).addAll(arg_0));
        return DataResult.success((Object)pixelsBuilder.build());
    }, List::of).fieldOf("sections").forGetter(GeoGlowingTextureMeta::pixels)).apply((Applicative)builder, GeoGlowingTextureMeta::new));
    public static final MetadataSectionType<GeoGlowingTextureMeta> TYPE = new MetadataSectionType("glowsections", CODEC);

    public static GeoGlowingTextureMeta fromExistingImage(NativeImage glowLayer) {
        ObjectArrayList pixels = new ObjectArrayList();
        for (int x = 0; x < glowLayer.getWidth(); ++x) {
            for (int y = 0; y < glowLayer.getHeight(); ++y) {
                int color = glowLayer.getPixel(x, y);
                if (color == 0) continue;
                pixels.add(new Pixel(x, y, ARGB.alpha((int)color)));
            }
        }
        if (pixels.isEmpty()) {
            throw new IllegalStateException("Invalid glow layer texture provided, must have at least one pixel!");
        }
        return new GeoGlowingTextureMeta((List<Pixel>)pixels);
    }

    public void createImageMask(NativeImage originalImage, NativeImage newImage) {
        for (Pixel pixel : this.pixels) {
            int color = originalImage.getPixel(pixel.x, pixel.y);
            if (pixel.alpha > 0) {
                color = ARGB.color((int)pixel.alpha, (int)ARGB.red((int)color), (int)ARGB.green((int)color), (int)ARGB.blue((int)color));
            }
            newImage.setPixel(pixel.x, pixel.y, color);
            originalImage.setPixel(pixel.x, pixel.y, 0);
        }
    }

    private record Pixel(int x, int y, int alpha) {
        public static final Codec<Pixel> SINGLE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("x").forGetter(Pixel::x), (App)Codec.INT.fieldOf("y").forGetter(Pixel::y), (App)Codec.INT.fieldOf("alpha").forGetter(Pixel::alpha)).apply((Applicative)builder, Pixel::new));
        public static final Codec<List<Pixel>> FROM_REGION_CODEC = Region.CODEC.flatComapMap(Region::toPixels, Region::fromPixels).validate(list -> list.isEmpty() ? DataResult.error(() -> "Empty region! Pixel region must have at least one pixel!") : DataResult.success((Object)list));

        private record Region(int xMin, int yMin, Either<Integer, Integer> x2, Either<Integer, Integer> y2, int alpha) {
            public static final Codec<Region> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.mapEither((MapCodec)Codec.INT.fieldOf("x1"), (MapCodec)Codec.INT.optionalFieldOf("x", (Object)0)).xmap(either -> (Integer)either.map(Function.identity(), Function.identity()), Either::right).forGetter(Region::xMin), (App)Codec.mapEither((MapCodec)Codec.INT.fieldOf("y1"), (MapCodec)Codec.INT.optionalFieldOf("y", (Object)0)).xmap(either -> (Integer)either.map(Function.identity(), Function.identity()), Either::right).forGetter(Region::yMin), (App)Codec.mapEither((MapCodec)Codec.INT.fieldOf("x2"), (MapCodec)Codec.INT.optionalFieldOf("w", (Object)0)).forGetter(Region::x2), (App)Codec.mapEither((MapCodec)Codec.INT.fieldOf("y2"), (MapCodec)Codec.INT.optionalFieldOf("h", (Object)0)).forGetter(Region::y2), (App)Codec.INT.optionalFieldOf("alpha", (Object)255).forGetter(Region::alpha)).apply((Applicative)builder, Region::new));

            private List<Pixel> toPixels() {
                int xMax = (Integer)this.x2.map(Function.identity(), w -> w + this.xMin);
                int yMax = (Integer)this.y2.map(Function.identity(), h -> h + this.yMin);
                ObjectArrayList pixels = new ObjectArrayList();
                for (int x = this.xMin; x <= xMax; ++x) {
                    for (int y = this.yMin; y <= yMax; ++y) {
                        pixels.add(new Pixel(x, y, this.alpha));
                    }
                }
                return pixels;
            }

            private static DataResult<Region> fromPixels(List<Pixel> pixels) {
                if (pixels.isEmpty()) {
                    return DataResult.error(() -> "Pixel region must not be empty!");
                }
                int minX = 0;
                int minY = 0;
                int maxX = 0;
                int maxY = 0;
                int alpha = pixels.getFirst().alpha;
                for (Pixel pixel : pixels) {
                    minX = Math.min(minX, pixel.x);
                    minY = Math.min(minY, pixel.y);
                    maxX = Math.max(maxX, pixel.x);
                    maxY = Math.max(maxY, pixel.y);
                    if (pixel.alpha == alpha) continue;
                    return DataResult.error(() -> "Pixel in region has mismatching alpha value! All pixels in a region must have the same alpha value");
                }
                if ((maxX - minX) * (maxY - minY) != pixels.size()) {
                    return DataResult.error(() -> "Invalid pixel region defined. Pixel regions must be contiguous square or rectangular sections");
                }
                return DataResult.success((Object)new Region(minX, minY, (Either<Integer, Integer>)Either.left((Object)maxX), (Either<Integer, Integer>)Either.left((Object)maxY), alpha));
            }
        }
    }
}

