/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.object.Color;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.service.GeckoLibClient;
import software.bernie.geckolib.util.RenderUtil;

public class ItemArmorGeoLayer<T extends LivingEntity>
extends GeoRenderLayer<T> {
    protected final EquipmentLayerRenderer equipmentRenderer;
    protected final Function<SkullBlock.Type, SkullModelBase> skullModels;
    @Nullable
    protected ItemStack mainHandStack;
    @Nullable
    protected ItemStack offhandStack;
    @Nullable
    protected ItemStack helmetStack;
    @Nullable
    protected ItemStack chestplateStack;
    @Nullable
    protected ItemStack leggingsStack;
    @Nullable
    protected ItemStack bootsStack;

    public ItemArmorGeoLayer(GeoRenderer<T> geoRenderer, EquipmentLayerRenderer equipmentLayerRenderer) {
        super(geoRenderer);
        this.equipmentRenderer = equipmentLayerRenderer;
        this.skullModels = Util.memoize(type -> SkullBlockRenderer.createModel((EntityModelSet)Minecraft.getInstance().getEntityModels(), (SkullBlock.Type)type));
    }

    @NotNull
    protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, T animatable) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || stack != animatable.getItemBySlot(slot)) continue;
            return slot;
        }
        return EquipmentSlot.CHEST;
    }

    @NotNull
    protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable, HumanoidModel<?> baseModel) {
        return baseModel.body;
    }

    @Nullable
    protected ItemStack getArmorItemForBone(GeoBone bone, T animatable) {
        return null;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        this.mainHandStack = animatable.getItemBySlot(EquipmentSlot.MAINHAND);
        this.offhandStack = animatable.getItemBySlot(EquipmentSlot.OFFHAND);
        this.helmetStack = animatable.getItemBySlot(EquipmentSlot.HEAD);
        this.chestplateStack = animatable.getItemBySlot(EquipmentSlot.CHEST);
        this.leggingsStack = animatable.getItemBySlot(EquipmentSlot.LEGS);
        this.bootsStack = animatable.getItemBySlot(EquipmentSlot.FEET);
    }

    @Override
    public void renderForBone(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        BlockItem blockItem;
        ItemStack armorStack = this.getArmorItemForBone(bone, animatable);
        if (armorStack == null || armorStack.isEmpty()) {
            return;
        }
        Item item = armorStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            this.renderSkullAsArmor(poseStack, bone, armorStack, skullBlock, bufferSource, packedLight);
        } else {
            EquipmentSlot slot = this.getEquipmentSlotForBone(bone, armorStack, animatable);
            HumanoidModel<?> model = this.getModelForItem(bone, slot, armorStack, animatable);
            ModelPart modelPart = this.getModelPartForBone(bone, slot, armorStack, animatable, model);
            if (!modelPart.cubes.isEmpty()) {
                poseStack.pushPose();
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                if (model instanceof GeoArmorRenderer) {
                    GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)model;
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    geoArmorRenderer.prepForRender((Entity)animatable, armorStack, slot, model, bufferSource, partialTick, 0.0f, 0.0f);
                    geoArmorRenderer.applyBoneVisibilityByPart(slot, modelPart, model);
                    geoArmorRenderer.renderToBuffer(poseStack, null, packedLight, packedOverlay, Color.WHITE.argbInt());
                } else {
                    Equippable equippable = (Equippable)armorStack.get(DataComponents.EQUIPPABLE);
                    if (equippable != null) {
                        equippable.assetId().ifPresent(modelPath -> {
                            this.prepModelPartForRender(poseStack, bone, modelPart);
                            this.renderVanillaArmorPiece(poseStack, animatable, bone, slot, armorStack, equippable, (ResourceKey<EquipmentAsset>)modelPath, model, modelPart, bufferSource, partialTick, packedLight, packedOverlay);
                        });
                    }
                }
                poseStack.popPose();
            }
        }
    }

    protected void renderVanillaArmorPiece(PoseStack poseStack, T animatable, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, Equippable equippable, ResourceKey<EquipmentAsset> equipmentAsset, HumanoidModel<?> model, ModelPart modelPart, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        EquipmentClientInfo.LayerType layerType = slot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
        this.setVanillaModelPartVisibility(animatable, armorStack, bone, model, modelPart, slot, partialTick);
        this.equipmentRenderer.renderLayers(layerType, equipmentAsset, model, armorStack, poseStack, bufferSource, packedLight);
    }

    @Deprecated(forRemoval=true)
    protected void setVanillaModelPartVisibility(HumanoidModel<?> baseModel, EquipmentSlot slot) {
    }

    protected void setVanillaModelPartVisibility(T animatable, ItemStack armorStack, GeoBone bone, HumanoidModel<?> baseModel, ModelPart modelPart, EquipmentSlot slot, float partialTick) {
        baseModel.setAllVisible(false);
        modelPart.visible = true;
    }

    @NotNull
    protected HumanoidModel<?> getModelForItem(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable) {
        HumanoidModel humanoidModel;
        HumanoidRenderState renderState;
        GeoEntityRenderer entityRenderer;
        HumanoidModel defaultModel = slot == EquipmentSlot.LEGS ? GeckoLibClient.GENERIC_INNER_ARMOR_MODEL.get() : GeckoLibClient.GENERIC_OUTER_ARMOR_MODEL.get();
        EntityRenderState entityRenderState = this.getRenderer();
        Model model = GeckoLibServices.Client.ITEM_RENDERING.getArmorModelForItem(animatable, entityRenderState instanceof GeoEntityRenderer && (entityRenderState = (entityRenderer = (GeoEntityRenderer)entityRenderState).getEntityRenderState()) instanceof HumanoidRenderState ? (renderState = (HumanoidRenderState)entityRenderState) : new HumanoidRenderState(), stack, slot, slot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID, defaultModel);
        return model instanceof HumanoidModel ? (humanoidModel = (HumanoidModel)model) : defaultModel;
    }

    protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
        SkullBlock.Type type = skullBlock.getType();
        SkullModelBase model = this.skullModels.apply(type);
        RenderType renderType = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)((ResolvableProfile)stack.get(DataComponents.PROFILE)));
        poseStack.pushPose();
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.scale(1.1875f, 1.1875f, 1.1875f);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (SkullModelBase)model, (RenderType)renderType);
        poseStack.popPose();
    }

    protected void prepModelPartForRender(PoseStack poseStack, GeoBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        ModelPart.Cube armorCube = (ModelPart.Cube)sourcePart.cubes.getFirst();
        double armorBoneSizeX = firstCube.size().x();
        double armorBoneSizeY = firstCube.size().y();
        double armorBoneSizeZ = firstCube.size().z();
        double actualArmorSizeX = Math.abs(armorCube.maxX - armorCube.minX);
        double actualArmorSizeY = Math.abs(armorCube.maxY - armorCube.minY);
        double actualArmorSizeZ = Math.abs(armorCube.maxZ - armorCube.minZ);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.setPos(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.xRot = -bone.getRotX();
        sourcePart.yRot = -bone.getRotY();
        sourcePart.zRot = bone.getRotZ();
        poseStack.scale(scaleX, scaleY, scaleZ);
    }
}

