/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtil;

public class AutoGlowingGeoLayer<T extends GeoAnimatable>
extends GeoRenderLayer<T> {
    public AutoGlowingGeoLayer(GeoRenderer<T> renderer) {
        super(renderer);
    }

    @Nullable
    protected RenderType getRenderType(T animatable, MultiBufferSource bufferSource) {
        if (!(animatable instanceof Entity)) {
            return AutoGlowingTexture.getRenderType(this.getTextureResource(animatable));
        }
        Entity entity = (Entity)animatable;
        boolean invisible = entity.isInvisible();
        ResourceLocation texture = AutoGlowingTexture.getEmissiveResource(this.getTextureResource(animatable));
        if (invisible && !entity.isInvisibleTo(ClientUtil.getClientPlayer())) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
        }
        if (Minecraft.getInstance().shouldEntityAppearGlowing(entity)) {
            if (invisible) {
                return RenderType.outline((ResourceLocation)texture);
            }
            return AutoGlowingTexture.getOutlineRenderType(this.getTextureResource(animatable));
        }
        return invisible ? null : AutoGlowingTexture.getRenderType(this.getTextureResource(animatable));
    }

    @Override
    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        renderType = this.getRenderType(animatable, bufferSource);
        if (renderType != null) {
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, this.getRenderer().getRenderColor(animatable, partialTick, packedLight).argbInt());
        }
    }
}

