/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public class GeoReplacedEntityRenderer<E extends Entity, T extends GeoAnimatable>
extends EntityRenderer<E, EntityRenderState>
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected final ItemModelResolver itemModelResolver;
    protected final T animatable;
    protected E currentEntity;
    protected float partialTick;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoReplacedEntityRenderer(EntityRendererProvider.Context context, GeoModel<T> model, T animatable) {
        super(context);
        this.model = model;
        this.itemModelResolver = context.getItemModelResolver();
        this.animatable = animatable;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public EntityRenderState getEntityRenderState() {
        return this.reusedState;
    }

    public E getCurrentEntity() {
        return this.currentEntity;
    }

    @Override
    public long getInstanceId(T animatable) {
        return this.currentEntity.getId();
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoReplacedEntityRenderer<E, T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoReplacedEntityRenderer<E, T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoReplacedEntityRenderer<E, T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @Nullable
    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        boolean invisible;
        boolean bl = invisible = this.currentEntity != null && this.currentEntity.isInvisible();
        if (invisible && !this.currentEntity.isInvisibleTo(ClientUtil.getClientPlayer())) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
        }
        if (!invisible) {
            return GeoRenderer.super.getRenderType(animatable, texture, bufferSource, partialTick);
        }
        return this.currentEntity != null && Minecraft.getInstance().shouldEntityAppearGlowing(this.currentEntity) ? RenderType.outline((ResourceLocation)texture) : null;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    @ApiStatus.Internal
    public void render(EntityRenderState entityRenderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, bufferSource, null, null, this.partialTick, packedLight);
    }

    @Override
    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        boolean isMoving;
        Direction bedDirection;
        Entity entity;
        LivingEntity entity2;
        poseStack.pushPose();
        E e = this.currentEntity;
        LivingEntity livingEntity = e instanceof LivingEntity ? (entity2 = (LivingEntity)e) : null;
        boolean shouldSit = this.currentEntity.isPassenger() && this.currentEntity.getVehicle() != null;
        float lerpBodyRot = livingEntity == null ? 0.0f : Mth.rotLerp((float)partialTick, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
        float lerpHeadRot = livingEntity == null ? 0.0f : Mth.rotLerp((float)partialTick, (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity = this.currentEntity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpBodyRot = Mth.rotLerp((float)partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.clamp((float)Mth.wrapDegrees((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (this.currentEntity.getPose() == Pose.SLEEPING && livingEntity != null && (bedDirection = livingEntity.getBedOrientation()) != null) {
            float eyePosOffset = livingEntity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-bedDirection.getStepX()) * eyePosOffset, 0.0f, (float)(-bedDirection.getStepZ()) * eyePosOffset);
        }
        float nativeScale = livingEntity != null ? livingEntity.getScale() : 1.0f;
        float ageInTicks = (float)((Entity)this.currentEntity).tickCount + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        poseStack.scale(nativeScale, nativeScale, nativeScale);
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
        if (!shouldSit && this.currentEntity.isAlive() && livingEntity != null) {
            limbSwingAmount = livingEntity.walkAnimation.speed(partialTick);
            limbSwing = livingEntity.walkAnimation.position(partialTick);
            if (livingEntity.isBaby()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        float headPitch = Mth.lerp((float)partialTick, (float)((Entity)this.currentEntity).xRotO, (float)this.currentEntity.getXRot());
        float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
        if (livingEntity != null) {
            Vec3 velocity = livingEntity.getDeltaMovement();
            float avgVelocity = (float)(Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0f;
            isMoving = avgVelocity >= motionThreshold && limbSwingAmount != 0.0f;
        } else {
            boolean bl = isMoving = limbSwingAmount <= -motionThreshold || limbSwingAmount >= motionThreshold;
        }
        if (!isReRender) {
            long instanceId = this.getInstanceId(animatable);
            AnimationState<T> animationState = this.createAnimationState(animatable, instanceId, limbSwing, limbSwingAmount, partialTick, isMoving);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.isBaby(), -netHeadYaw, -headPitch));
            this.getGeoModel().handleAnimations(animatable, instanceId, animationState, partialTick);
        }
        poseStack.translate(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        }
        poseStack.popPose();
    }

    @Override
    public AnimationState<T> createAnimationState(T animatable, long instanceId, float limbSwing, float limbSwingAmount, float partialTick, boolean isMoving) {
        AnimationState<T> animationState = GeoRenderer.super.createAnimationState(animatable, instanceId, limbSwing, limbSwingAmount, partialTick, isMoving);
        animationState.setData(DataTickets.TICK, animatable.getTick(this.currentEntity));
        animationState.setData(DataTickets.ENTITY, this.currentEntity);
        return animationState;
    }

    @Override
    public void applyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        if (!this.currentEntity.isSpectator()) {
            GeoRenderer.super.applyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public void renderFinal(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        super.render(this.getEntityRenderState(), poseStack, bufferSource, packedLight);
    }

    @Override
    public void postRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            super.render(this.getEntityRenderState(), poseStack, bufferSource, packedLight);
        }
    }

    @Override
    public void doPostRenderCleanup() {
        this.currentEntity = null;
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        poseStack.pushPose();
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.translateMatrix(localMatrix, this.getRenderOffset(this.getEntityRenderState()).toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtil.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.currentEntity.position().toVector3f()));
        }
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
        buffer = this.checkAndRefreshBuffer(isReRender, buffer, bufferSource, renderType);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, renderColor);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        poseStack.popPose();
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        E e;
        if (this.isShaking(animatable)) {
            rotationYaw += (float)(Math.cos((double)((Entity)this.currentEntity).tickCount * 3.25) * Math.PI * 0.4);
        }
        if (!this.currentEntity.hasPose(Pose.SLEEPING)) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        }
        if ((e = this.currentEntity) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)e;
            if (livingEntity.deathTime > 0) {
                float deathRotation = ((float)livingEntity.deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.mulPose(Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
            } else if (livingEntity.isAutoSpinAttack()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f - livingEntity.getXRot()));
                poseStack.mulPose(Axis.YP.rotationDegrees(((float)livingEntity.tickCount + partialTick) * -75.0f));
            } else if (livingEntity.hasPose(Pose.SLEEPING)) {
                Direction bedOrientation = livingEntity.getBedOrientation();
                poseStack.mulPose(Axis.YP.rotationDegrees(bedOrientation != null ? RenderUtil.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getDeathMaxRotation(animatable)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            } else if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)livingEntity)) {
                poseStack.translate(0.0f, (livingEntity.getBbHeight() + 0.1f) / nativeScale, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(E entity, T animatable) {
        return 32.0;
    }

    public boolean shouldShowName(E entity, double distToCameraSq) {
        double nameRenderCutoff;
        if (!(entity instanceof LivingEntity)) {
            return super.shouldShowName(entity, distToCameraSq);
        }
        if (entity.isDiscrete() && distToCameraSq >= (nameRenderCutoff = this.getNameRenderCutoffDistance(entity, this.animatable)) * nameRenderCutoff) {
            return false;
        }
        if (!(!(entity instanceof Mob) || entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean visibleToClient = !entity.isInvisibleTo((Player)minecraft.player);
        PlayerTeam entityTeam = entity.getTeam();
        if (entityTeam == null) {
            return Minecraft.renderNames() && entity != minecraft.getCameraEntity() && visibleToClient && !entity.isVehicle();
        }
        PlayerTeam playerTeam = minecraft.player.getTeam();
        return switch (entityTeam.getNameTagVisibility()) {
            default -> throw new MatchException(null, null);
            case Team.Visibility.ALWAYS -> visibleToClient;
            case Team.Visibility.NEVER -> false;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.isAlliedTo((Team)playerTeam) && (entityTeam.canSeeFriendlyInvisibles() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? visibleToClient : !entityTeam.isAlliedTo((Team)playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(T animatable, float u, float partialTick) {
        E e = this.currentEntity;
        if (!(e instanceof LivingEntity)) {
            return OverlayTexture.NO_OVERLAY;
        }
        LivingEntity entity = (LivingEntity)e;
        return OverlayTexture.pack((int)OverlayTexture.u((float)u), (int)OverlayTexture.v((entity.hurtTime > 0 || entity.deathTime > 0 ? 1 : 0) != 0));
    }

    public boolean isShaking(T animatable) {
        return this.currentEntity.isFullyFrozen();
    }

    @ApiStatus.Internal
    @Nullable
    public EntityRenderState createRenderState() {
        return null;
    }

    @ApiStatus.Internal
    public final EntityRenderState createRenderState(E entity, float partialTick) {
        this.currentEntity = entity;
        this.partialTick = partialTick;
        if (this.reusedState == null) {
            this.reusedState = entity instanceof LivingEntity ? new LivingEntityRenderState() : new EntityRenderState();
        }
        this.extractRenderState(entity, this.reusedState, partialTick);
        return this.reusedState;
    }

    @ApiStatus.Internal
    public void extractRenderState(E entity, EntityRenderState entityRenderState, float partialTick) {
        super.extractRenderState(entity, entityRenderState, partialTick);
        if (entityRenderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)entityRenderState;
            RenderUtil.prepLivingEntityRenderState((LivingEntity)entity, livingEntityRenderState, partialTick, this.itemModelResolver);
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileReplacedEntityRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return GeckoLibServices.Client.EVENTS.fireReplacedEntityPreRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }

    @Override
    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        GeckoLibServices.Client.EVENTS.fireReplacedEntityPostRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }
}

