/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.loading.math.MolangQueries;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.object.Color;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public interface GeoRenderer<T extends GeoAnimatable> {
    public GeoModel<T> getGeoModel();

    public T getAnimatable();

    default public ResourceLocation getTextureLocation(T animatable) {
        return this.getGeoModel().getTextureResource(animatable, this);
    }

    default public List<GeoRenderLayer<T>> getRenderLayers() {
        return List.of();
    }

    @Nullable
    default public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return this.getGeoModel().getRenderType(animatable, texture);
    }

    default public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    default public int getPackedOverlay(T animatable, float u, float partialTick) {
        return OverlayTexture.NO_OVERLAY;
    }

    default public long getInstanceId(T animatable) {
        return animatable.hashCode();
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public void defaultRender(PoseStack poseStack, T animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float partialTick, int packedLight) {
        poseStack.pushPose();
        int renderColor = this.getRenderColor(animatable, partialTick, packedLight).argbInt();
        int packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        BakedGeoModel model = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(animatable, this));
        if (renderType == null) {
            renderType = this.getRenderType(animatable, this.getTextureLocation(animatable), bufferSource, partialTick);
        }
        if (buffer == null && renderType != null) {
            buffer = bufferSource.getBuffer(renderType);
        }
        this.preRender(poseStack, animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor);
        if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
            this.preApplyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, packedLight, packedLight, packedOverlay, renderColor);
            this.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor);
            this.applyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
            this.postRender(poseStack, animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor);
            this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
        }
        poseStack.popPose();
        this.renderFinal(poseStack, animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        this.doPostRenderCleanup();
        MolangQueries.clearActor();
    }

    default public void reRender(BakedGeoModel model, PoseStack poseStack, MultiBufferSource bufferSource, T animatable, RenderType renderType, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        poseStack.pushPose();
        this.preRender(poseStack, animatable, model, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, renderColor);
        this.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, renderColor);
        this.postRender(poseStack, animatable, model, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, renderColor);
        poseStack.popPose();
    }

    default public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        if (buffer == null) {
            if (renderType == null) {
                return;
            }
            buffer = bufferSource.getBuffer(renderType);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(animatable));
        for (GeoBone group : model.topLevelBones()) {
            this.renderRecursively(poseStack, animatable, group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    default public void preApplyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    default public void applyRenderLayersForBone(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.renderForBone(poseStack, animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    default public void applyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.render(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    default public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void postRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void renderFinal(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void doPostRenderCleanup() {
    }

    default public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        poseStack.pushPose();
        RenderUtil.prepMatrixForBone(poseStack, bone);
        buffer = this.checkAndRefreshBuffer(isReRender, buffer, bufferSource, renderType);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, renderColor);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, this.getAnimatable(), bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor);
        }
        this.renderChildBones(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        poseStack.popPose();
    }

    default public void renderCubesOfBone(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.getCubes()) {
            poseStack.pushPose();
            this.renderCube(poseStack, cube, buffer, packedLight, packedOverlay, renderColor);
            poseStack.popPose();
        }
    }

    default public void renderChildBones(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (GeoBone childBone : bone.getChildBones()) {
            this.renderRecursively(poseStack, animatable, childBone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, renderColor);
        }
    }

    default public void renderCube(PoseStack poseStack, GeoCube cube, VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        RenderUtil.translateToPivotPoint(poseStack, cube);
        RenderUtil.rotateMatrixAroundCube(poseStack, cube);
        RenderUtil.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.last().normal();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtil.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(quad, poseState, normal, buffer, packedLight, packedOverlay, renderColor);
        }
    }

    default public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.addVertex(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    default public AnimationState<T> createAnimationState(T animatable, long instanceId, float limbSwing, float limbSwingAmount, float partialTick, boolean isMoving) {
        AnimationState<T> animationState = new AnimationState<T>(animatable, limbSwing, limbSwingAmount, partialTick, isMoving);
        this.getGeoModel().addAdditionalStateData((GeoAnimatable)animatable, instanceId, (BiConsumer<DataTicket<GeoAnimatable>, GeoAnimatable>)((BiConsumer<DataTicket, GeoAnimatable>)animationState::setData));
        return animationState;
    }

    public void fireCompileRenderLayersEvent();

    public boolean firePreRenderEvent(PoseStack var1, BakedGeoModel var2, MultiBufferSource var3, float var4, int var5);

    public void firePostRenderEvent(PoseStack var1, BakedGeoModel var2, MultiBufferSource var3, float var4, int var5);

    default public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            poseStack.scale(widthScale, heightScale, widthScale);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    default public VertexConsumer checkAndRefreshBuffer(boolean isReRender, VertexConsumer buffer, MultiBufferSource bufferSource, RenderType renderType) {
        VertexConsumer vertexConsumer;
        if (isReRender) {
            return buffer;
        }
        VertexConsumer vertexConsumer2 = buffer;
        Objects.requireNonNull(vertexConsumer2);
        VertexConsumer vertexConsumer3 = vertexConsumer2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BufferBuilder.class, OutlineBufferSource.EntityOutlineGenerator.class, VertexMultiConsumer.Double.class}, (Object)vertexConsumer3, n)) {
                case 0: {
                    BufferBuilder builder = (BufferBuilder)vertexConsumer3;
                    if (builder.building) {
                        n = 1;
                        continue block5;
                    }
                    vertexConsumer = bufferSource.getBuffer(renderType);
                    break block5;
                }
                case 1: {
                    OutlineBufferSource.EntityOutlineGenerator outlines = (OutlineBufferSource.EntityOutlineGenerator)vertexConsumer3;
                    if (!this.bufferNeedsRefresh(outlines.delegate())) {
                        n = 2;
                        continue block5;
                    }
                    vertexConsumer = new OutlineBufferSource.EntityOutlineGenerator(bufferSource.getBuffer(renderType), outlines.color());
                    break block5;
                }
                case 2: {
                    VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)vertexConsumer3;
                    if (!this.bufferNeedsRefresh(pair.first) && !this.bufferNeedsRefresh(pair.second)) {
                        n = 3;
                        continue block5;
                    }
                    vertexConsumer = new VertexMultiConsumer.Double(this.bufferNeedsRefresh(pair.first) ? bufferSource.getBuffer(renderType) : pair.first, this.bufferNeedsRefresh(pair.second) ? bufferSource.getBuffer(renderType) : pair.second);
                    break block5;
                }
                default: {
                    vertexConsumer = buffer;
                    break block5;
                }
            }
            break;
        }
        return vertexConsumer;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    private boolean bufferNeedsRefresh(VertexConsumer buffer) {
        VertexConsumer vertexConsumer = buffer;
        Objects.requireNonNull(vertexConsumer);
        VertexConsumer vertexConsumer2 = vertexConsumer;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BufferBuilder.class, OutlineBufferSource.EntityOutlineGenerator.class, VertexMultiConsumer.Double.class}, (Object)vertexConsumer2, n)) {
            case 0 -> {
                BufferBuilder builder = (BufferBuilder)vertexConsumer2;
                if (!builder.building) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                OutlineBufferSource.EntityOutlineGenerator outlines = (OutlineBufferSource.EntityOutlineGenerator)vertexConsumer2;
                yield this.bufferNeedsRefresh(outlines.delegate());
            }
            case 2 -> {
                VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)vertexConsumer2;
                if (this.bufferNeedsRefresh(pair.first) || this.bufferNeedsRefresh(pair.second)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

