/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.platform;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.service.GeckoLibClient;

public final class GeckoLibClientForge
implements GeckoLibClient {
    @Override
    @NotNull
    public <E extends LivingEntity, S extends HumanoidRenderState> Model getArmorModelForItem(E animatable, S entityRenderState, ItemStack stack, EquipmentSlot slot, EquipmentClientInfo.LayerType type, HumanoidModel<S> defaultModel) {
        HumanoidModel<?> humanoidModel;
        Item item = stack.getItem();
        HumanoidModel model = IClientItemExtensions.of((Item)item).getHumanoidArmorModel(entityRenderState, stack, slot, defaultModel);
        if (model == defaultModel && (humanoidModel = GeoRenderProvider.of(item).getGeoArmorRenderer(animatable, stack, slot, type, defaultModel)) instanceof GeoArmorRenderer) {
            GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)humanoidModel;
            return geoArmorRenderer;
        }
        return model;
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForItem(ItemStack item) {
        GeoItemRenderer<?> geoItemRenderer = GeoRenderProvider.of(item).getGeoItemRenderer();
        if (geoItemRenderer instanceof GeoRenderer) {
            GeoItemRenderer<?> geoRenderer = geoItemRenderer;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForArmor(ItemStack armour, EquipmentSlot slot, EquipmentClientInfo.LayerType type) {
        HumanoidModel defaultModel = slot == EquipmentSlot.LEGS ? (HumanoidModel)GENERIC_INNER_ARMOR_MODEL.get() : (HumanoidModel)GENERIC_OUTER_ARMOR_MODEL.get();
        HumanoidModel<?> humanoidModel = IClientItemExtensions.of((ItemStack)armour).getHumanoidArmorModel(new LivingEntityRenderState(), armour, slot, defaultModel);
        if (humanoidModel instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)humanoidModel;
            return armorRenderer.getGeoModel();
        }
        humanoidModel = GeoRenderProvider.of(armour).getGeoArmorRenderer(null, armour, slot, type, defaultModel);
        if (humanoidModel instanceof GeoArmorRenderer) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)humanoidModel;
            return armorRenderer.getGeoModel();
        }
        return null;
    }
}

