/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public record StopTriggeredEntityAnimPacket(int entityId, boolean isReplacedEntity, Optional<String> controllerName, Optional<String> animName) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<StopTriggeredEntityAnimPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("stop_triggered_entity_anim"));
    public static final StreamCodec<FriendlyByteBuf, StopTriggeredEntityAnimPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StopTriggeredEntityAnimPacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, StopTriggeredEntityAnimPacket::isReplacedEntity, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), StopTriggeredEntityAnimPacket::controllerName, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), StopTriggeredEntityAnimPacket::animName, StopTriggeredEntityAnimPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            Entity entity = ClientUtil.getLevel().getEntity(this.entityId);
            if (entity == null) {
                return;
            }
            if (!this.isReplacedEntity) {
                if (entity instanceof GeoEntity) {
                    GeoEntity geoEntity = (GeoEntity)entity;
                    geoEntity.stopTriggeredAnim(this.controllerName.orElse(null), this.animName.orElse(null));
                }
                return;
            }
            GeoAnimatable patt0$temp = RenderUtil.getReplacedAnimatable(entity.getType());
            if (patt0$temp instanceof GeoReplacedEntity) {
                GeoReplacedEntity replacedEntity = (GeoReplacedEntity)patt0$temp;
                replacedEntity.stopTriggeredAnim(entity, this.controllerName.orElse(null), this.animName.orElse(null));
            }
        });
    }
}

