/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.json.typeadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.math.NumberUtils;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.Keyframe;
import software.bernie.geckolib.animation.keyframe.KeyframeStack;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.value.Constant;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.object.CompoundException;
import software.bernie.geckolib.util.JsonUtil;

public class BakedAnimationsAdapter
implements JsonDeserializer<BakedAnimations> {
    public BakedAnimations deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws RuntimeException {
        JsonObject obj = json.getAsJsonObject();
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            try {
                animations.put((String)entry.getKey(), this.bakeAnimation((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), context));
            }
            catch (Exception ex) {
                if (ex instanceof CompoundException) {
                    CompoundException compoundEx = (CompoundException)ex;
                    GeckoLibConstants.LOGGER.error(compoundEx.withMessage("Unable to parse animation: " + (String)entry.getKey()).getLocalizedMessage());
                } else {
                    GeckoLibConstants.LOGGER.error("Unable to parse animation: " + (String)entry.getKey());
                }
                ex.printStackTrace();
            }
        }
        return new BakedAnimations((Map<String, Animation>)animations);
    }

    private Animation bakeAnimation(String name, JsonObject animationObj, JsonDeserializationContext context) throws CompoundException {
        double length = animationObj.has("animation_length") ? GsonHelper.getAsDouble((JsonObject)animationObj, (String)"animation_length") * 20.0 : -1.0;
        Animation.LoopType loopType = Animation.LoopType.fromJson(animationObj.get("loop"));
        BoneAnimation[] boneAnimations = this.bakeBoneAnimations(GsonHelper.getAsJsonObject((JsonObject)animationObj, (String)"bones", (JsonObject)new JsonObject()));
        Animation.Keyframes keyframes = (Animation.Keyframes)context.deserialize((JsonElement)animationObj, Animation.Keyframes.class);
        if (length == -1.0) {
            length = BakedAnimationsAdapter.calculateAnimationLength(boneAnimations);
        }
        return new Animation(name, length, loopType, boneAnimations, keyframes);
    }

    private BoneAnimation[] bakeBoneAnimations(JsonObject bonesObj) throws CompoundException {
        BoneAnimation[] animations = new BoneAnimation[bonesObj.size()];
        int index = 0;
        for (Map.Entry entry : bonesObj.entrySet()) {
            JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            KeyframeStack<Keyframe<MathValue>> scaleFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getTripletObj(entryObj.get("scale")), false);
            KeyframeStack<Keyframe<MathValue>> positionFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getTripletObj(entryObj.get("position")), false);
            KeyframeStack<Keyframe<MathValue>> rotationFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getTripletObj(entryObj.get("rotation")), true);
            animations[index] = new BoneAnimation((String)entry.getKey(), rotationFrames, positionFrames, scaleFrames);
            ++index;
        }
        return animations;
    }

    private static List<Pair<String, JsonElement>> getTripletObj(JsonElement element) {
        if (element == null) {
            return List.of();
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonArray array = new JsonArray(3);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            element = array;
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)"0", (Object)array)});
        }
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            ObjectArrayList list = new ObjectArrayList();
            KeyframeType lastKeyframeType = KeyframeType.LINEAR;
            for (Map.Entry entry : obj.entrySet()) {
                JsonObject entryObj;
                Object v = entry.getValue();
                if (v instanceof JsonObject && !(entryObj = (JsonObject)v).has("vector")) {
                    Pair<Pair<String, JsonElement>, KeyframeType> result = BakedAnimationsAdapter.getTripletObjBedrock((String)entry.getKey(), entryObj, lastKeyframeType);
                    list.add((Pair)result.getFirst());
                    lastKeyframeType = (KeyframeType)((Object)result.getSecond());
                    continue;
                }
                list.add(Pair.of((Object)((String)entry.getKey()), (Object)((JsonElement)entry.getValue())));
            }
            return list;
        }
        throw new JsonParseException("Invalid object type provided to getTripletObj, got: " + String.valueOf(element));
    }

    private static Pair<Pair<String, JsonElement>, KeyframeType> getTripletObjBedrock(String timestamp, JsonObject keyframe, KeyframeType lastKeyframesType) {
        JsonObject keyframeValues = new JsonObject();
        switch (lastKeyframesType.ordinal()) {
            case 0: {
                keyframeValues.addProperty("easing", "catmullrom");
                break;
            }
            case 1: {
                keyframeValues.addProperty("easing", "single_step");
            }
        }
        if (keyframe.isJsonArray()) {
            keyframeValues.add("vector", (JsonElement)keyframe);
            return Pair.of((Object)Pair.of((Object)(NumberUtils.isCreatable((String)timestamp) ? timestamp : "0"), (Object)keyframeValues), (Object)((Object)KeyframeType.LINEAR));
        }
        if (keyframe.has("post")) {
            if (keyframe.has("lerp_mode")) {
                JsonArray array;
                JsonElement post = keyframe.get("post");
                JsonArray jsonArray = array = post.isJsonArray() ? post.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)post.getAsJsonObject(), (String)"vector");
                if (array != null) {
                    keyframeValues.add("vector", (JsonElement)array);
                    return Pair.of((Object)Pair.of((Object)(NumberUtils.isCreatable((String)timestamp) ? timestamp : "0"), (Object)keyframeValues), (Object)((Object)KeyframeType.SMOOTH));
                }
            } else if (keyframe.has("pre")) {
                JsonElement pre = keyframe.get("pre");
                JsonArray array = pre.isJsonArray() ? pre.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)pre.getAsJsonObject(), (String)"vector");
                keyframeValues.add("vector", (JsonElement)array);
                keyframeValues.add("post", keyframe.get("post"));
                return Pair.of((Object)Pair.of((Object)(NumberUtils.isCreatable((String)timestamp) ? timestamp : "0"), (Object)keyframeValues), (Object)((Object)KeyframeType.STEP));
            }
        }
        throw new JsonParseException("Invalid keyframe data - expected array, found " + String.valueOf(keyframe));
    }

    private KeyframeStack<Keyframe<MathValue>> buildKeyframeStack(List<Pair<String, JsonElement>> entries, boolean isForRotation) throws CompoundException {
        if (entries.isEmpty()) {
            return new KeyframeStack<Keyframe<MathValue>>();
        }
        ObjectArrayList xFrames = new ObjectArrayList();
        ObjectArrayList yFrames = new ObjectArrayList();
        ObjectArrayList zFrames = new ObjectArrayList();
        MathValue xPrev = null;
        MathValue yPrev = null;
        MathValue zPrev = null;
        Pair<String, JsonElement> prevEntry = null;
        JsonArray bedrockPost = null;
        for (Pair<String, JsonElement> entry : entries) {
            JsonObject obj;
            JsonArray array;
            String key = (String)entry.getFirst();
            JsonElement element = (JsonElement)entry.getSecond();
            if (key.equals("easing") || key.equals("easingArgs") || key.equals("lerp_mode")) continue;
            double prevTime = prevEntry != null ? Double.parseDouble((String)prevEntry.getFirst()) : 0.0;
            double curTime = NumberUtils.isCreatable((String)key) ? Double.parseDouble((String)entry.getFirst()) : 0.0;
            double timeDelta = curTime - prevTime;
            JsonArray keyFrameVector = element instanceof JsonArray ? (array = (JsonArray)element) : GsonHelper.getAsJsonArray((JsonObject)element.getAsJsonObject(), (String)"vector");
            MathValue rawXValue = MathParser.parseJson(keyFrameVector.get(0));
            MathValue rawYValue = MathParser.parseJson(keyFrameVector.get(1));
            MathValue rawZValue = MathParser.parseJson(keyFrameVector.get(2));
            MathValue xValue = isForRotation && rawXValue instanceof Constant ? new Constant(Math.toRadians(-rawXValue.get())) : rawXValue;
            MathValue yValue = isForRotation && rawYValue instanceof Constant ? new Constant(Math.toRadians(-rawYValue.get())) : rawYValue;
            MathValue zValue = isForRotation && rawZValue instanceof Constant ? new Constant(Math.toRadians(rawZValue.get())) : rawZValue;
            JsonObject entryObj = element instanceof JsonObject ? (obj = (JsonObject)element) : null;
            EasingType easingType = entryObj != null && entryObj.has("easing") ? EasingType.fromJson(entryObj.get("easing")) : EasingType.LINEAR;
            ObjectArrayList easingArgs = entryObj != null && entryObj.has("easingArgs") ? JsonUtil.jsonArrayToList(GsonHelper.getAsJsonArray((JsonObject)entryObj, (String)"easingArgs"), ele -> new Constant(ele.getAsDouble())) : new ObjectArrayList();
            boolean separateArgs = easingType == EasingType.SINGLE_STEP || easingType == EasingType.CATMULLROM;
            xFrames.add(new Keyframe<MathValue>(timeDelta * 20.0, prevEntry == null ? xValue : xPrev, xValue, easingType, (List<MathValue>)(separateArgs ? new ObjectArrayList() : easingArgs)));
            yFrames.add(new Keyframe<MathValue>(timeDelta * 20.0, prevEntry == null ? yValue : yPrev, yValue, easingType, (List<MathValue>)(separateArgs ? new ObjectArrayList() : easingArgs)));
            zFrames.add(new Keyframe<MathValue>(timeDelta * 20.0, prevEntry == null ? zValue : zPrev, zValue, easingType, (List<MathValue>)(separateArgs ? new ObjectArrayList() : easingArgs)));
            xPrev = xValue;
            yPrev = yValue;
            zPrev = zValue;
            prevEntry = entry;
            if (easingType == EasingType.SINGLE_STEP && bedrockPost != null) {
                rawXValue = MathParser.parseJson(bedrockPost.get(0));
                rawYValue = MathParser.parseJson(bedrockPost.get(1));
                rawZValue = MathParser.parseJson(bedrockPost.get(2));
                xValue = isForRotation && rawXValue instanceof Constant ? new Constant(Math.toRadians(-rawXValue.get())) : rawXValue;
                yValue = isForRotation && rawYValue instanceof Constant ? new Constant(Math.toRadians(-rawYValue.get())) : rawYValue;
                zValue = isForRotation && rawZValue instanceof Constant ? new Constant(Math.toRadians(rawZValue.get())) : rawZValue;
                ((Keyframe)xFrames.getLast()).easingArgs().add(xValue);
                ((Keyframe)yFrames.getLast()).easingArgs().add(yValue);
                ((Keyframe)zFrames.getLast()).easingArgs().add(zValue);
            }
            if (entryObj == null || !entryObj.has("post")) continue;
            bedrockPost = entryObj.getAsJsonArray("post");
        }
        this.applyCatmullRomEasing((List<Keyframe<MathValue>>)xFrames);
        this.applyCatmullRomEasing((List<Keyframe<MathValue>>)yFrames);
        this.applyCatmullRomEasing((List<Keyframe<MathValue>>)zFrames);
        return new KeyframeStack<Keyframe<MathValue>>((List<Keyframe<MathValue>>)xFrames, (List<Keyframe<MathValue>>)yFrames, (List<Keyframe<MathValue>>)zFrames);
    }

    private void applyCatmullRomEasing(List<Keyframe<MathValue>> frames) {
        for (int i = 0; i < frames.size(); ++i) {
            Keyframe<MathValue> frame = frames.get(i);
            if (frame.easingType() != EasingType.CATMULLROM) continue;
            frame.easingArgs().add(i - 2 >= 0 ? frames.get(i - 2).endValue() : frames.get(0).endValue());
            frame.easingArgs().add(i + 1 < frames.size() - 1 ? frames.get(i + 1).endValue() : frames.get(frames.size() - 1).endValue());
        }
    }

    private static double calculateAnimationLength(BoneAnimation[] boneAnimations) {
        double length = 0.0;
        for (BoneAnimation animation : boneAnimations) {
            length = Math.max(length, animation.rotationKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.positionKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.scaleKeyFrames().getLastKeyframeTime());
        }
        return length == 0.0 ? Double.MAX_VALUE : length;
    }

    public static enum KeyframeType {
        SMOOTH,
        STEP,
        LINEAR;

    }
}

